% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.r
\name{datasets}
\alias{datasets}
\title{Search for datasets and dataset metadata.}
\usage{
datasets(
  data = "all",
  type = NULL,
  uuid = NULL,
  query = NULL,
  id = NULL,
  limit = 100,
  start = NULL,
  curlopts = list()
)
}
\arguments{
\item{data}{The type of data to get. One or more of: 'organization',
'contact', 'endpoint', 'identifier', 'tag', 'machinetag', 'comment',
'constituents', 'document', 'metadata', 'deleted', 'duplicate',
'subDataset', 'withNoEndpoint', or the special 'all'. Default: \code{all}}

\item{type}{Type of dataset. Options: include occurrence, checklist,
metadata, or sampling_event.}

\item{uuid}{UUID of the data node provider. This must be specified if data
is anything other than \code{all}}

\item{query}{Query term(s). Only used when \code{data=all}}

\item{id}{A metadata document id.}

\item{limit}{Number of records to return. Default: 100. Maximum: 1000.}

\item{start}{Record number to start at. Default: 0. Use in combination
with \code{limit} to page through results.}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{\link[curl]{curl_options}}
for curl options}
}
\value{
A list.
}
\description{
Search for datasets and dataset metadata.
}
\examples{
\dontrun{
datasets(limit=5)
datasets(type="occurrence", limit=10)
datasets(uuid="a6998220-7e3a-485d-9cd6-73076bd85657")
datasets(data='contact', uuid="a6998220-7e3a-485d-9cd6-73076bd85657")
datasets(data='metadata', uuid="a6998220-7e3a-485d-9cd6-73076bd85657")
datasets(data='metadata', uuid="a6998220-7e3a-485d-9cd6-73076bd85657",
  id=598)
datasets(data=c('deleted','duplicate'))
datasets(data=c('deleted','duplicate'), limit=1)

# curl options
datasets(data=c('deleted','duplicate'), curlopts = list(verbose=TRUE))
}
}
\references{
\url{http://www.gbif.org/developer/registry#datasets}
}
