% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbif_citation.R
\name{gbif_citation}
\alias{gbif_citation}
\title{Get citation for datasets used}
\usage{
gbif_citation(x)
}
\arguments{
\item{x}{(character) Result of call to \code{\link[=occ_download_get]{occ_download_get()}}, \code{\link[=occ_download_meta]{occ_download_meta()}}.}
}
\value{
list with S3 class assigned, used by a print method to pretty print
citation information. Though you can unclass the output or just index to the
named items as needed.
}
\description{
Get citation for datasets used
}
\details{
The function is deprecated for use with \code{\link[=occ_search]{occ_search()}} and \code{\link[=occ_data]{occ_data()}}
results, and is deprecated for use with datasetKeys and gbifids. Instead,
we encourage you to use \code{\link[=derived_dataset]{derived_dataset()}} instead.

\code{\link[=occ_download_get]{occ_download_get()}} and \code{\link[=occ_download_meta]{occ_download_meta()}} results are still supported.
}
\examples{
\dontrun{
# Downloads
## occ_download_get()
# d1 <- occ_download(pred("country", "BG"), pred_gte("year", 2020))
# occ_download_meta(d1) # wait until status = succeeded
# d1 <- occ_download_get(d1, overwrite = TRUE)
# gbif_citation(d1)

## occ_download_meta()
# key <- "0000122-171020152545675"
# res <- occ_download_meta(key)
# gbif_citation(res)
}
}
