% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_get.R
\name{ee_get}
\alias{ee_get}
\title{Return the element at the specified position in a Earth Engine Collection}
\usage{
ee_get(ee_c, index = 0)
}
\arguments{
\item{ee_c}{ImageCollection or FeatureCollection.}

\item{index}{Numeric. Specified position.}
}
\value{
Depending of \code{ee_c} can return either an ee$FeatureCollection
or ee$ImageCollection.
}
\description{
Return the element at the specified position in a Earth Engine Collection
}
\examples{
\dontrun{
library(rgee)
library(sf)

ee_Initialize()

nc <- st_read(system.file("shape/nc.shp", package = "sf")) \%>\%
  st_transform(4326) \%>\%
  sf_as_ee()

ee_s2 <- ee$ImageCollection("COPERNICUS/S2")$
  filterDate("2016-01-01", "2016-01-31")$
  filterBounds(nc)

ee_s2$size()$getInfo() # 126

# Get the first 5 elements
ee_get(ee_s2, index = 0:4)$size()$getInfo() # 5
}
}
