% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_as_ee.R
\name{stars_as_ee}
\alias{stars_as_ee}
\title{Convert a stars or stars-proxy object into an EE Image object}
\usage{
stars_as_ee(
  x,
  assetId,
  bucket = NULL,
  predefinedAcl = "bucketLevel",
  command_line_tool_path = NULL,
  overwrite = FALSE,
  monitoring = TRUE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{x}{stars or stars-proxy object to be converted into an ee$Image.}

\item{assetId}{Character. Destination asset ID for the uploaded file.}

\item{bucket}{Character. Name of the GCS bucket.}

\item{predefinedAcl}{Specify user access to object. Passed to
\code{googleCloudStorageR::gcs_upload}.}

\item{command_line_tool_path}{Character. Path to the Earth Engine command line
tool (CLT). If NULL, rgee assumes that CLT is set in the system PATH.
(ignore if \code{via} is not defined as "gcs_to_asset").}

\item{overwrite}{Logical. If TRUE, the assetId will be overwritten.}

\item{monitoring}{Logical. If TRUE the exportation task will be monitored.}

\item{quiet}{Logical. Suppress info message.}

\item{...}{parameter(s) passed on to \code{\link{ee_utils_create_manifest_image}}}
}
\value{
An ee$Image object
}
\description{
Convert a stars or stars-proxy object into an EE Image object
}
\examples{
\dontrun{
library(rgee)
library(stars)
ee_Initialize(gcs = TRUE)

# Get the filename of a image
tif <- system.file("tif/L7_ETMs.tif", package = "stars")
x <- read_stars(tif)
assetId <- sprintf("\%s/\%s",ee_get_assethome(),'stars_l7')

# # Method 1
# 1. Move from local to gcs
gs_uri <- local_to_gcs(x = tif, bucket = 'rgee_dev')

# 2. Create a manifest
manifest <- ee_utils_create_manifest_image(gs_uri, assetId)

# 3. Pass from gcs to asset
gcs_to_ee_image(
  manifest = manifest,
  overwrite = TRUE
)

# OPTIONAL: Monitoring progress
ee_monitoring(max_attempts = Inf)

# OPTIONAL: Display results
ee_stars_01 <- ee$Image(assetId)
Map$centerObject(ee_stars_01)
Map$addLayer(ee_stars_01, list(min = 0, max = 255))

# Method 2
ee_stars_02 <- stars_as_ee(
 x = x,
 overwrite = TRUE,
 assetId = assetId,
 bucket = "rgee_dev"
)
Map$centerObject(ee_stars_02)
Map$addLayer(ee_stars_02, list(min = 0, max = 255))
}
}
\seealso{
Other image upload functions: 
\code{\link{raster_as_ee}()}
}
\concept{image upload functions}
