% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{mean_neighbors}
\alias{mean_neighbors}
\title{Mean Neighbors of Spatial Weights}
\usage{
mean_neighbors(gda_w)
}
\arguments{
\item{gda_w}{A Weight object}
}
\value{
The number of mean neighbors of spatial weights
}
\description{
Get the number of mean neighbors of spatial weights
}
\examples{
\dontrun{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
queen_w <- queen_weights(guerry)
mean_neighbors(queen_w)
}
}
