% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{lisa_colors}
\alias{lisa_colors}
\title{Get cluster colors}
\usage{
lisa_colors(gda_lisa)
}
\arguments{
\item{gda_lisa}{An instance of LISA object}
}
\value{
A string vector of cluster colors
}
\description{
Get the cluster colors of LISA computation.
}
\examples{
\dontrun{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
queen_w <- queen_weights(guerry)
lisa <- local_moran(queen_w, guerry["Crm_prs"])
clrs <- lisa_colors(lisa)
clrs
}
}
