% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{percentile_breaks}
\alias{percentile_breaks}
\title{Percentile Breaks}
\usage{
percentile_breaks(data)
}
\arguments{
\item{data}{A vector of numeric values}
}
\value{
A vector of numeric values of computed breaks
}
\description{
Percentile breaks data into 6 groups: the lowest 1%, 1-10%, 10-50%, 50-90%, 90-99% and the top 1%.
}
\examples{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
guerry_df <- as.data.frame(guerry) # use as data.frame
crm_prs <- guerry_df['Crm_prs'][,1] # get values of variable "crm_prs"
percentile_breaks(data=crm_prs)
}
