% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lisa.R
\name{lisa_clusters}
\alias{lisa_clusters}
\title{Get local cluster indicators}
\usage{
lisa_clusters(gda_lisa, cutoff = 0)
}
\arguments{
\item{gda_lisa}{An instance of LISA object}

\item{cutoff}{A value of cutoff for significance p-values to filter not-significant clusters, default=0.0, means not used}
}
\value{
A numeric vector of LISA cluster indicator
}
\description{
Get the local cluster indicators returned from LISA computation.
}
\examples{
\dontrun{
library(sf)
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- st_read(guerry_path)
queen_w <- queen_weights(guerry)
lisa <- local_moran(queen_w, guerry["Crm_prs"])
clsts <- lisa_clusters(lisa)
clsts
}
}
