#' Geospatial Quality Flags
#'
#' This document describes how the Geospatial Quality API (service for which
#' this package works as a wrapper) works. Specifically, it describes the data
#' input format and enumerates and briefly describes the possible geospatial
#' quality flags that the API returns.
#'
#' @section Input:
#'
#'   The API operates on Primary Biodiversity Records, \emph{i.e.}, the most basic,
#'   interpretation-free pieces of information about the occurrence of an
#'   organism (taxonomic identification, or "what") in a specific place
#'   (geospatial location, or "where") and a moment in time (temporal location,
#'   or "when"). It feeds on a single record or a set of records that describe
#'   such occurrence. Specifically, the geospatial issues service works with the
#'   "what" and the "where", meaning it is more useful if such pieces of
#'   information are provided to the API.
#'
#'   While there is no minimum set of required values to pass to the service in
#'   order for it to work, the amount of tests to be performed depends on the
#'   information provided. One can simply call the base URL and it will return a
#'   set of empty fields. To fully leverage the potential of the API, however, a
#'   user should send a well-defined set of values. These values must conform to
#'   the \href{http://rs.tdwg.org/dwc/terms/index.htm}{DarwinCore Standard}, and
#'   currently, the API works on these variables:
#'
#'   \describe{ \item{decimalLatitude}{Value for the Latitude in decimal degrees
#'   format (e.g. 42.332)} \item{decimalLongitude}{Value for the Longitude in
#'   decimal degrees format (e.g. -1.833)} \item{countryCode}{2 character ISO
#'   code for the country} \item{scientificName}{Species the record belongs to}}
#'   \strong{Caveat}: while the API accepts scientific names as specified in the
#'   DarwinCore Standard, currently some tools only work if the
#'   "Genus"+"Specific Epithet" binomial is provided in this field. Thus,
#'   instead of "Puma concolor (Linnaeus, 1771)", we recommend using just "Puma
#'   concolor" in the 'scientificName' field.
#'
#'   When working with multiple records (using the \code{\link{add_flags}}
#'   function in this package), the API accepts more than just these fields. One
#'   can send a data.frame with as many columns as he/she wants, and the API
#'   will just by-pass them. They will be presented in the output, though, so it
#'   is a good practice to include a field with any type of identification (like
#'   an occurrenceID).
#'
#' @section Output format:
#'
#'   The output of the API will always be a JSON document, which will be
#'   transformed into a data.frame in this package. Actually, the API will
#'   return the same document that was provided, with the addition of the flags
#'   element. This new element contains the results of the geospatial and
#'   spatio-taxonomic checks the API has performed. The attributes in this flags
#'   element are one or more of these (depending on the information provided):
#'
#'   \describe{
#'
#'   \item{hasCoordinates}{always. TRUE if coordinates have been sent to the
#'   API. FALSE otherwise.}
#'
#'   \item{hasCountry}{always. TRUE if a country value has been sent to the API.
#'   FALSE otherwise.}
#'
#'   \item{hasScientificName}{always. TRUE if a scientific name has been sent to
#'   the API. FALSE otherwise.}
#'
#'   \item{validCoordinates}{only if hasCoordinates is TRUE. TRUE if supplied
#'   values conform to the natural limits of coordinates. FALSE otherwise.}
#'
#'   \item{validCountry}{only if hasCountry is TRUE. TRUE if supplied value
#'   corresponds to an existing 2-character code for a country. FALSE
#'   otherwise.}
#'
#'   \item{highPrecisionCoordinates}{only if validCoordinates is TRUE. TRUE if
#'   coordinates have at least 3 decimal figures. FALSE otherwise.}
#'
#'   \item{nonZeroCoordinates}{only if validCoordinates is TRUE. FALSE if both
#'   coordinates are 0. TRUE otherwise.}
#'
#'   \item{coordinatesInsideCountry}{Only if validCoordinates and validCountry
#'   are TRUE. TRUE if coordinates fall inside the specified country. FALSE
#'   otherwise.}
#'
#'   \item{transposedCoordinates}{Only if coordinatesInsideCountry is FALSE.
#'   TRUE if swapping the coordinates makes them right. FALSE otherwise. This
#'   operation can be performed along negatedLatitude and negatedLongitude.}
#'
#'   \item{negatedLatitude}{Only if coordinatesInsideCountry is FALSE. TRUE if
#'   negating the latitude makes coordinates right. FALSE otherwise. This
#'   operation can be performed along transposedCoordinates and
#'   negatedLongitude.}
#'
#'   \item{negatedLongitude}{Only if coordinatesInsideCountry is FALSE. TRUE if
#'   negating the longitude makes coordinates right. FALSE otherwise. This
#'   operation can be performed along transposedCoordinates and
#'   negatedLatitude.}
#'
#'   \item{distanceToCountryInKm}{Only if coordinatesInsideCountry,
#'   transposedCoordinates, negatedLatitude and negatedLongitude are FALSE. This
#'   will show the distance to the closest point of the country boundaries, in
#'   Km.}
#'
#'   \item{coordinatesInsideRangeMap}{Only if hasScientificName and
#'   validCoordinates are TRUE. TRUE if coordinates fall inside the IUCN range
#'   map for the specified species. FALSE otherwise.}
#'
#'   \item{distanceToRangeMapInKm}{Only if coordinatesInsideRangeMap is FALSE.
#'   This will show the distance to the closest point of the species range map,
#'   in Km.}}
#'
#' @seealso \code{\link{add_flags}}, \code{\link{format_gq}},
#'   \code{\link{parse_record}}
#'
#' @name flags
NULL
