\name{makeRegressionFitnessFunction}
\alias{makeRegressionFitnessFunction}
\title{Create a fitness function for symbolic regression}
\usage{
  makeRegressionFitnessFunction(formula, data, envir,
    errorMeasure = rmse, indsizelimit = NA,
    penalizeGenotypeConstantIndividuals = FALSE,
    subSamplingShare = 1)
}
\arguments{
  \item{formula}{A formula object describing the regression
  task.}

  \item{data}{An optional data frame containing the
  variables in the model.}

  \item{envir}{The R environment to evaluate individuals
  in.}

  \item{errorMeasure}{A function to use as an error
  measure, defaults to RMSE.}

  \item{indsizelimit}{Individuals exceeding this size limit
  will get a fitness of \code{Inf}.}

  \item{penalizeGenotypeConstantIndividuals}{Individuals
  that do not contain any input variables will get a
  fitness of \code{Inf}.}

  \item{subSamplingShare}{The share of fitness cases
  \deqn{s} sampled for evaluation with each function
  evaluation. \deqn{0 < s \leq 1} must hold, defaults to
  \code{1.0}.}
}
\value{
  A fitness function to be used in symbolic regression.
}
\description{
  Creates a fitness function that calculates an error
  measure with respect to a given set of data variables. A
  simplified version of the formula syntax is used to
  describe the regression task. When an \code{indsizelimit}
  is given, individuals exceeding this limit will receive a
  fitness of \code{Inf}.
}

