\name{sind}
\alias{sind}
\docType{data}
\title{ Sinding-Larsen Norwegian Stream Sediment Test Data Set }
\description{
A small subset of data from a regional geochemical stream sediment survey undertaken by the Norwegian Geological Survey.
}
\usage{data(sind)}
\format{
  A data frame with 25 observations on the following 9 variables:
  \describe{
    \item{ID}{ an arbitrary ID (numeric vector). }
    \item{E}{ an Eastings coordinate. }
    \item{N}{ a Northings coordinate. }
    \item{Zn}{ zinc (mg/kg) in stream sediment. }
    \item{Fe}{ iron (\%) in stream sediment. }
    \item{Mn}{ manganese (mg/kg) in stream sediment. }
    \item{Cd}{ cadmium (mg/kg) in stream sediment. }
    \item{Cu}{ copper (mg/kg) in stream sediment. }
    \item{Pb}{ lead (mg/kg) in stream sediment. }
  }
}
\details{
These data were used by Howarth and Sinding-Larsen (1983) to demonstrate the use of a number of multivariate statistical analysis techniques.  Other authors, e.g., Howarth and Garrett (1986) and Garrett and Grunsky (2001) have also used the data set for demonstration purposes.
}
\source{
Howarth and Sinding-Larson (1983), see below.  Spatial coordinates added by digitizing Fig. 6-1 (op. cit.).
}
\references{
Howarth, R.J. and Sinding-Larsen, R., 1983. Multivariate analysis.  Chapter 6 of Handbook of Exploration Geochemistry, Vol. 2, Statistics and Data Analysis in Geochemical Prospecting (Ed. R.J. Howarth), Elsevier, pp. 207-289.

Howarth, R.J. and Garrett, R.G., 1986. The role of computing in applied geochemistry.  In Applied Geochemistry in the 1980s (Eds. I. Thornton and R.J. Howarth), Graham and Trotman, London, pp. 163-184.

Garrett, R.G. and Grunsky, E.G., 2001. Weighted Sums - Knowledge based empirical indices for use in exploration geochemistry.  Geochemistry: Exploration, Environment and Analysis, 1(2):135-141.
}
\keyword{datasets}
