% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_graph6.R
\name{as_graph6}
\alias{as_graph6}
\alias{as_graph6.matrix}
\alias{as_graph6.igraph}
\alias{as_graph6.network}
\alias{as_graph6.list}
\alias{as_graph6.default}
\title{Encode network data as 'graph6' symbols}
\usage{
as_graph6(object)

\method{as_graph6}{matrix}(object)

\method{as_graph6}{igraph}(object)

\method{as_graph6}{network}(object)

\method{as_graph6}{list}(object)

\method{as_graph6}{default}(object)
}
\arguments{
\item{object}{a matrix, an igraph object or a network object or a list
thereof. See Methods section below.}
}
\value{
A character vector of 'graph6' symbols.
}
\description{
Generic function encoding undirected networks as 'graph6' symbol(s). See
below for available methods.
}
\details{
The 'graph6' format is designed for undirected graphs. Error is thrown
in case it is given a directed graph.
}
\section{Methods (by class)}{
\itemize{
\item \code{matrix}: Expects \code{object} to be a square matrix which is
interpreted as an adjacency matrix of an undirected graph. The function
reads only the upper triangle of the matrix and there is no test whether
the matrix is symmetric.

\item \code{igraph}: Igraph \code{object} needs to be an undirected graph.
Requires \pkg{igraph} package.

\item \code{network}: Network \code{object} needs to be a directed network.
Requires \pkg{network} package.

\item \code{list}: If \code{object} is a list the function is applied to each
element. Consequently, it can be a list with a mixture of supported objects
classes (adjacency matrices, igraph, or network objects).

\item \code{default}: The default method throws an error about an unhandled
class.
}}

\examples{
# From adjacency matrix ----------------------------------------------------
am <- matrix(c(
  0,1,1,
  1,0,0,
  1,0,0
  ), byrow=TRUE, ncol=3)
as_graph6(am)

# From igraph objects ------------------------------------------------------
if(requireNamespace("igraph", quietly=TRUE)) {
  g <- igraph::graph_from_adjacency_matrix(am, mode = "undirected")
  as_graph6(g)
}

# From network objects -----------------------------------------------------
if(requireNamespace("network", quietly=TRUE)) {
  net <- network::network(am, directed=FALSE)
  as_graph6(net)
}

}
