% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choose_format.R
\name{choose_format}
\alias{choose_format}
\alias{choose_format.default}
\alias{choose_format.list}
\title{Choose most efficient format heuristically}
\usage{
choose_format(object, ...)

\method{choose_format}{default}(object, ...)

\method{choose_format}{list}(object, ...)
}
\arguments{
\item{object}{Igraph/network object or list thereof}

\item{...}{other arguments, currently ignored}
}
\value{
Character value out of 'graph6', 'sparse6' or 'digraph6'. If \code{object}
is a list, a vector of such values of the length equal to the length of
\code{object}.
}
\description{
Given a graph suggest the most efficient format out of 'graph6', 'sparse6' or
'digraph6'.
}
\details{
If \code{object} is directed, the suggested format is 'digraph6'. If
\code{object} is undirected the function suggests 'sparse6' if density is less
than 0.15 and 'graph6' otherwise. This rule is approximate.
}
\examples{
# From igraph ------------------------------------------------------
if(requireNamespace("igraph")) {
   g <- igraph::graph.famous("Zachary")
   choose_format(g)
   
   set.seed(123)
   glist <- list(
      igraph::sample_gnp(n = 15, p = 0.1),
      igraph::sample_gnp(n = 15, p = 0.2), 
      igraph::sample_gnp(n = 15, p = 0.3),
      igraph::sample_gnp(n = 15, p = 0.15, directed = TRUE))
      
   choose_format(glist)
}

# From network -----------------------------------------------------
if(requireNamespace("network")) {
   m <- matrix(rbinom(25,1,.4),15,15)
   diag(m) <- 0
   g <- network::network(m, directed=FALSE)
   choose_format(g)
}
}
