% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-preprocessing.R
\name{DiagramScaler}
\alias{DiagramScaler}
\title{Preprocessing: Diagram Scaler}
\description{
This is a class for preprocessing persistence diagrams with a
given list of scalers, such as those included in \strong{scikit-learn}.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
dgm <- st$compute_persistence()$persistence_intervals_in_dimension(0)
ds <- DiagramScaler$new()
ds$apply(dgm)
ds$fit_transform(list(dgm))
\dontshow{\}) # examplesIf}
}
\author{
Mathieu Carrière
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:PreprocessingStep]{rgudhi::PreprocessingStep}} -> \code{DiagramScaler}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DiagramScaler-new}{\code{DiagramScaler$new()}}
\item \href{#method-DiagramScaler-clone}{\code{DiagramScaler$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PreprocessingStep" data-id="apply"><a href='../../rgudhi/html/PreprocessingStep.html#method-PreprocessingStep-apply'><code>rgudhi::PreprocessingStep$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PreprocessingStep" data-id="fit"><a href='../../rgudhi/html/PreprocessingStep.html#method-PreprocessingStep-fit'><code>rgudhi::PreprocessingStep$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PreprocessingStep" data-id="fit_transform"><a href='../../rgudhi/html/PreprocessingStep.html#method-PreprocessingStep-fit_transform'><code>rgudhi::PreprocessingStep$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PreprocessingStep" data-id="transform"><a href='../../rgudhi/html/PreprocessingStep.html#method-PreprocessingStep-transform'><code>rgudhi::PreprocessingStep$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DiagramScaler-new"></a>}}
\if{latex}{\out{\hypertarget{method-DiagramScaler-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{DiagramScaler}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiagramScaler$new(use = FALSE, scalers = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use}}{A boolean value specifying whether to use the class. Defaults
to \code{FALSE}.}

\item{\code{scalers}}{A list of scalers to be fit on the persistence diagrams.
Defaults to \code{list()} which is an empty list. Each element of the list
is a length-2 \link[base:list]{base::list} with two elements:
\itemize{
\item the first one is a list of coordinates;
\item the second one is an instantiated scaler class. Choices are
\link{MaxAbsScaler}, \link{MinMaxScaler}, \link{RobustScaler} or \link{StandardScaler}.
}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{DiagramScaler}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DiagramScaler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DiagramScaler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DiagramScaler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
