% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-vector-methods.R
\name{Silhouette}
\alias{Silhouette}
\title{Vector Representation: Silhouette}
\description{
Computes persistence silhouettes from a list of persistence
diagrams. A persistence silhouette is computed by taking a weighted average
of the collection of 1D piecewise-linear functions given by the persistence
landscapes, and then by evenly sampling this average on a given range.
Finally, the corresponding vector of samples is returned. See
https://arxiv.org/abs/1312.0308 for more details.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
dgm <- st$compute_persistence()$persistence_intervals_in_dimension(0)
ds <- DiagramSelector$new(use = TRUE)
dgm <- ds$apply(dgm)
sil <- Silhouette$new()
sil$apply(dgm) # TO DO: fix gd because it does not set sample_range automatically
sil$fit_transform(list(dgm))
\dontshow{\}) # examplesIf}
}
\author{
Mathieu Carrière
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:VectorRepresentationStep]{rgudhi::VectorRepresentationStep}} -> \code{Silhouette}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Silhouette-new}{\code{Silhouette$new()}}
\item \href{#method-Silhouette-clone}{\code{Silhouette$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="apply"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-apply'><code>rgudhi::VectorRepresentationStep$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="fit"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-fit'><code>rgudhi::VectorRepresentationStep$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="fit_transform"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-fit_transform'><code>rgudhi::VectorRepresentationStep$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="transform"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-transform'><code>rgudhi::VectorRepresentationStep$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Silhouette-new"></a>}}
\if{latex}{\out{\hypertarget{method-Silhouette-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{Silhouette}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Silhouette$new(weight = ~1, resolution = 100, sample_range = rep(NA_real_, 2))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{weight}}{A function or a formula coercible into a function via
\code{\link[rlang:as_function]{rlang::as_function()}} specifying the weight function for the
persistence diagram points. Defaults to the constant function \code{~ 1}.
This function must be defined on 2D points, i.e. lists or arrays of the
form \eqn{[p_x,p_y]}.}

\item{\code{resolution}}{An length-1 integer vector specifying the size (in
pixels) of the persistence image. Defaults to \code{rep(20L, 2)}.}

\item{\code{sample_range}}{A length-2 numeric vector specifying the domain for
the entropy summary function, of the form \eqn{[x_{\min}, x_{\max}]}.
Defaults to \code{rep(NA, 2)}. It is the interval on which samples will be
drawn evenly. If one of the values is \code{NA}, it can be computed from the
persistence diagrams with the \verb{$fit()} method.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{Silhouette}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Silhouette-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Silhouette-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Silhouette$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
