% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhandsontable.R
\name{hot_table}
\alias{hot_table}
\title{Handsontable widget}
\usage{
hot_table(hot, contextMenu = TRUE, stretchH = "none",
  customBorders = NULL, highlightRow = NULL, highlightCol = NULL,
  enableComments = FALSE, overflow = NULL, ...)
}
\arguments{
\item{hot}{rhandsontable object}

\item{contextMenu}{logical enabling the right-click menu}

\item{stretchH}{character describing column stretching. Options are 'all', 'right',
and 'none'. See \href{http://docs.handsontable.com/0.16.1/demo-stretching.html}{Column stretching} for details.}

\item{customBorders}{json object. See
\href{http://handsontable.com/demo/custom_borders.html}{Custom borders} for details.}

\item{highlightRow}{logical enabling row highlighting for the selected
cell}

\item{highlightCol}{logical enabling column highlighting for the
selected cell}

\item{enableComments}{logical enabling comments in the table}

\item{overflow}{character setting the css overflow behavior. Options are
auto (default), hidden and visible}

\item{...}{passed to \href{http://handsontable.com}{Handsontable.js} constructor}
}
\description{
Configure table.  See
\href{http://handsontable.com}{Handsontable.js} for details.
}
\examples{
library(rhandsontable)
DF = data.frame(val = 1:10, bool = TRUE, big = LETTERS[1:10],
                small = letters[1:10],
                dt = seq(from = Sys.Date(), by = "days", length.out = 10),
                stringsAsFactors = FALSE)

rhandsontable(DF) \%>\%
hot_table(highlightCol = TRUE, highlightRow = TRUE)
}
\seealso{
\code{\link{rhandsontable}}
}

