###
# Get Handset
#
# This function is to get a handset of a set and calculate the kappa
# @param set This is the set to take a handset of
# @param handSetLength This is the length of the handset to take
# @param handSetBaserate This is the minimum baserate to inflate the handset to
# @param returnSet If TRUE, then return the handSet if FALSE, return the kappa of the handSet
# @keywords handset, hand, inflation
# @return The function returns the handSet if returnSet is TRUE or the kappa of the handSet if not
###
getHandSet = function(set, handSetLength, handSetBaserate, returnSet=FALSE) {
  #positives is the minimum number of positive pairs in the first rater
  positives = ceiling(handSetLength * handSetBaserate);
  posInd = which(set[,1] == 1);

  if(positives > length(posInd)){stop("Not enough positives in first rater to inflate to this level")}
  #if there is an inflated baserate positives will be > 0, so if handSetBaserate > 0, positives > 0
  if (positives > 0) {
    #goes through and picks a set that fits the number of positives first then randomly samples from the rest
    #if the set created is not a valid set, then it reruns the process until a valid set is found
      
      positiveIndices = posInd[sample.int(length(posInd),size=positives,replace=FALSE)];
      others = set[!(1:nrow(set) %in% positiveIndices),];
      otherIndices = sample.int(nrow(others),size=(handSetLength - positives),replace=FALSE);
      this.set = rbind(set[positiveIndices,], others[otherIndices,]);
      #ORIGINAL CODE BEFORE THE SWITCH TO TOTAL RANDOM POST POSITIVE SAMPLING - BJR 10/10/16
      #tp = set[which(set[,1] == 1),];
      #positiveIndices = sample(1:nrow(tp),size=positives,replace=FALSE);
      #others = set[which(set[,1] == 0),];
      #otherIndices = sample(1:nrow(others),size=(handSetLength - positives),replace=FALSE);
      #handSet = rbind(tp[positiveIndices,],others[otherIndices,]);
      #handSetKappa = calcKappa(handSet);
  } else if (positives == 0){
    #if there is no restriction on positives, then the set is generated by randomly sampling from the entire set
    #this.set=matrix(0,2,2);
    #while ((sum(this.set[,2]) == 0 | sum(this.set[,2]) == nrow(this.set))) {
      theseIndices = sample.int(nrow(set),size=handSetLength,replace=FALSE);
      this.set = set[theseIndices,];
    #}
  }

  #if return set is true return set rather than kappa
  if(returnSet){
    return(this.set);
  }

  #otherwise return the kappa of the set
  handSetKappa = calcKappa(this.set);
  return(handSetKappa);
}