% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhoMin.R
\name{rhoMin}
\alias{rhoMin}
\title{Rho Min}
\usage{
rhoMin(baserate, alpha = 0.05, inc = 10, printInc = FALSE, ...)
}
\arguments{
\item{baserate}{A \code{\link{baserate}}}

\item{alpha}{The threshold of significance for rho (similar to an alpha level for a p value), defaulted to 0.05}

\item{inc}{An integer indicating by how much the testSetLength should increase each iteration}

\item{printInc}{A boolean indicating whether to print out each increment value with it's corresponding significance for rho}

\item{...}{Any additional parameters passed into \code{\link{rho}}}
}
\value{
The minimum length of testSet, to the nearest multiple of inc, greater than the minimum length, that would give a value where rho less than alpha becomes mathematically possible.
}
\description{
This function calculates the minimum testSetLength where it is possible to get a rho less than alpha for the given parameters of rho.
}
\examples{
#Add testSetBaserateInflation as an additional parameter
rhoMin(0.2, testSetBaserateInflation = 0.33)

#Add testSetBaserateInflation as well as changing inc and selecting printInc
rhoMin(0.2, inc = 5, printInc = TRUE, testSetBaserateInflation = 0.33)

}
\keyword{rhoMin}

