% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rhoCT.R
\name{rhoCT}
\alias{rhoCT}
\title{Rho (contingency Table)}
\usage{
rhoCT(contingencyTable, OcSBaserate = NULL, testSetBaserateInflation = 0,
  OcSLength = 10000, replicates = 800, ScSKappaThreshold = 0.65,
  ScSKappaMin = 0.4, ScSPrecisionMin = 0.6, ScSPrecisionMax = 1)
}
\arguments{
\item{contingencyTable}{The \code{\link{contingencyTable}} used to calculate rho}

\item{OcSBaserate}{The \code{\link{baserate}} of the observed \code{\link{codeSet}} (defaults to \code{\link{baserate}} of the \code{\link{contingencyTable}})}

\item{testSetBaserateInflation}{The minimum \code{\link{baserate}} from the sampling procedure}

\item{OcSLength}{The length of the observed \code{\link{codeSet}}}

\item{replicates}{The number of simulated \code{\link[=getTestSet]{codeSets}} to use in the null hypothesis distribution for rho; similar to replicates in a Monte Carlo study}

\item{ScSKappaThreshold}{The maximum kappa value used to generate simulated \code{\link[=getTestSet]{codeSets}} in the null hypothesis distribution for rho}

\item{ScSKappaMin}{The minimum kappa value used to generate simulated \code{\link[=getTestSet]{codeSets}} in the null hypothesis distribution for rho}

\item{ScSPrecisionMin}{The minimum precision to be used for generation of simulated \code{\link[=getTestSet]{codeSets}} in the null hypothesis distribution for rho}

\item{ScSPrecisionMax}{The maximum precision to be used for generation of simulated \code{\link[=getTestSet]{codeSets}} in the null hypothesis distribution for rho}
}
\value{
A list of the format:\describe{
\item{rho}{The rho of the \code{\link{contingencyTable}}}
\item{kappa}{The Cohen's Kappa of the \code{\link{contingencyTable}}}
}
}
\description{
This function calculates rho and kappa for a given \code{\link{contingencyTable}}, and returns a list containing both values. Called by \code{\link{rho}}.
}
\seealso{
\code{\link{rho}} and \code{\link{rhoK}} and \code{\link{rhoSet}}
}
\keyword{rhoCT}
