% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_definition.R
\name{hype_info}
\alias{hype_info}
\title{Print More Detail About a Hypergraph}
\usage{
hype_info(
  hype,
  numv = TRUE,
  elist = TRUE,
  vnames = TRUE,
  vweights = TRUE,
  enames = TRUE,
  eweights = TRUE,
  weighted = TRUE,
  oriented = TRUE,
  directed = TRUE,
  real_coef = TRUE,
  inc_mat = TRUE
)
}
\arguments{
\item{hype}{A hypergraph object}

\item{numv}{A logical variable indicating whether information about the
number of vertices should be printed}

\item{elist}{A logical variable indicating whether information about the
hyperedge list should be printed}

\item{vnames}{A logical variable indicating whether information about the
vertex names should be printed}

\item{vweights}{A logical variable indicating whether information about the
vertex weights should be printed}

\item{enames}{A logical variable indicating whether information about the
hyperedge names should be printed}

\item{eweights}{A logical variable indicating whether information about the
hyperedge weights should be printed}

\item{weighted}{A logical variable indicating whether information about the
hypergraph weighting should be printed}

\item{oriented}{A logical variable indicating whether information about the
hypergraph orientation should be printed}

\item{directed}{A logical variable indicating whether information about the
hypergraph direction should be printed}

\item{real_coef}{A logical variable indicating whether information about the
hypergraph real coefficients should be printed}

\item{inc_mat}{A logical variable indicating whether information about the
hypergraph incidence matrix should be printed}
}
\description{
Get a more detailed printout of what is contained within a hypergraph object
to understand more about its structure as a whole without having to
repeatedly call other functions.
}
\details{
This gives a more detailed look at the whole hypegraph object. It is
intended solely to  aid the user when using rhype and generally should not be
included in final scripts. If a user wants to include this in their final
script it is instead heavily encouraged that they use other rhype functions to
generate their own bespoke messages.
}
\examples{
hype1 <- example_hype()
hype_info(hype1)

hype2 <- example_hype(vertex_weighted = TRUE, edge_weighted = TRUE)
hype_info(hype2)

hype3 <- example_hype(oriented = TRUE, directed = TRUE, real_coef = TRUE)
hype_info(hype3)
}
