% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalisedKinship_karigl.R
\name{generalised_karigl}
\alias{generalised_karigl}
\alias{generalisedKinship3}
\alias{generalisedKinship4}
\alias{generalisedKinship22}
\title{Karigl's generalised kinship coefficients}
\usage{
generalisedKinship3(
  x,
  ids,
  sparse = NA,
  chromType = "autosomal",
  verbose = FALSE
)

generalisedKinship4(
  x,
  ids,
  sparse = NA,
  chromType = "autosomal",
  verbose = FALSE
)

generalisedKinship22(
  x,
  ids,
  sparse = NA,
  chromType = "autosomal",
  verbose = FALSE
)
}
\arguments{
\item{x}{A pedigree, in the form of a \code{\link[pedtools:ped]{pedtools::ped}} object.}

\item{ids}{A vector of ID labels, of length 3 for \code{generalisedKinship3()} and
4 for \code{generalisedKinship4()} and \code{generalisedKinship22()}.}

\item{sparse}{A positive integer, indicating the pedigree size limit for
using sparse arrays. If NA, a default limit of 50 is used.}

\item{chromType}{Either "autosomal" or "x".}

\item{verbose}{A logical.}
}
\value{
A numeric of length 1.
}
\description{
Compute generalised kinship coefficients, as defined by Karigl (1981),
involving up to 4 pedigree members. The founders may be inbred; see Examples.
}
\details{
The function \code{generalisedKinship3()} computes the generalised kinship
coefficient of three (not necessarily distinct) members \code{a}, \code{b} and \code{c},
defined as the probability that if a random allele is chosen from each of
them, they are all identical by descent.

The function \code{generalisedKinship4()} computes the generalised kinship
coefficient of four individuals, defined similarly to the above.

The function \code{generalisedKinship22()} computes the generalised kinship
coefficient of two pairs of members, defined as the probability that in both
pairs simultaneously, random alleles chosen from the two individuals are IBD.
}
\examples{
# Generalised kinship between three siblings
x = nuclearPed(3)
phi3 = generalisedKinship3(x, ids = 3:5)

# Recalculate if the father is 100\% inbred
founderInbreeding(x, 1) = 1
phi3_inbred = generalisedKinship3(x, ids = 3:5)

stopifnot(phi3 == 1/16, phi3_inbred == 1/8 + 1/32)

}
\seealso{
\code{\link[=kinship]{kinship()}}, \code{\link[=kinshipX]{kinshipX()}}, \code{\link[=condensedIdentity]{condensedIdentity()}},
\code{\link[=condensedIdentityX]{condensedIdentityX()}}
}
