% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identicalMatrix.R
\name{identicalMatrix}
\alias{identicalMatrix}
\title{Test whether two matrices are identical by values and by dim names}
\usage{
identicalMatrix(x, y, epsilon = 1e-12)
}
\arguments{
\item{x}{a matrix}

\item{y}{another matrix}

\item{epsilon}{accuracy threshold: absolute differences below this threshold
is ignored}
}
\value{
Logical
}
\description{
Test whether two matrices are identical by values and by dim names
}
\examples{

set.seed(1887); x <- matrix(rnorm(1000), nrow=10, dimnames=list(LETTERS[1:10],NULL))
set.seed(1887); y <- matrix(rnorm(1000), nrow=10, dimnames=list(LETTERS[1:10],NULL))
set.seed(1887); z <- matrix(rnorm(1000), nrow=10, dimnames=list(letters[1:10],NULL))
stopifnot(identicalMatrix(x,y))
stopifnot(!identicalMatrix(x,z))

}
