% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marine.R
\name{shells.mean}
\alias{shells.mean}
\title{Plot and summarize the dR values}
\usage{
shells.mean(
  dat,
  feeding = c(),
  draw = TRUE,
  distance = FALSE,
  pch = 20,
  col.mn = 1,
  lty.mn = 2,
  col.sd = rgb(0, 0, 0, 0.1)
)
}
\arguments{
\item{dat}{The data, as returned from the function 'plot.shells'.}

\item{feeding}{Whether or not to select a specific feeding behaviour. Defaults to empty (no selection of feeding behaviour).}

\item{draw}{Whether or not to draw the values.}

\item{distance}{Plot the dR values according to their distance (if you've used find.shells; assumes that 'dat' has a final column with the distances).}

\item{pch}{Symbol to be plotted. Defaults to a closed circle (\code{pch=20}).}

\item{col.mn}{Colour for the weighted mean. Defaults to black, \code{col.mn=1}.}

\item{lty.mn}{Line type for the weighted mean. Defaults to dashed, \code{lty.mn=2}.}

\item{col.sd}{Colour of the rectangle of the error. Defaults to transparent grey, \code{col.sd=rgb(0,0,0,.1)}.}
}
\value{
A plot of the dR values, as well as the weighted mean (vertical line) and (weighted) error (rectangle).
}
\description{
After selecting a relevant range of shell values, plot them and calculate the weighted mean and variance.
}
\examples{
 N_UK <- map.shells(53, -11, 60, 2, mapsize="small")
 shells.mean(N_UK)
 nearby <- find.shells(0,56,20) # somewhere in Scotland
 shells.mean(nearby, distance=TRUE) # distance matters
}
