\name{predict.ridgeLinear}
\alias{predict.ridgeLinear}

\title{
  Predict method for \code{linearRidge} model fits.
}

\description{
  Predicted values based on \code{ridgeLinear} model object.
}

\usage{
\method{predict}{ridgeLinear}(object, newdata, na.action = na.pass, all.coef = FALSE, ...)
}

\arguments{
  \item{object}{
    Object of class \code{ridgeLinear}, typically generated by a call to \code{linearRidge}.
  }
  \item{newdata}{
    An optional data frame in which to look for variables with which to
  predict. If omited, the fitted values are used.
  }
  \item{na.action}{
    Function determining what should be done with missing values
    in \code{newdata}.  The default is to predict \code{NA}.
  }
  \item{all.coef}{
    Logical. Should results be returned for all ridge regression
    penalty parameters (\code{all.coef = TRUE}), or only for the ridge
    parameter chosen automatically?
  }
  \item{\dots}{
    Additional arguments to be passed to or from other methods.
  }
}
\details{
   \code{predict.ridgeLinear} produces predicted values, obtained by evaluating the
   regression function in the frame \code{newdata} (which defaults to
   \code{model.frame(object)}).
   
   If \code{newdata} is omitted the predictions are based on the data used
   for the fit.
}
\value{
  Depends on the call to \code{linearRidge} used to generate
  \code{object}. If \code{linearRidge} was called with only one value of \code{lambda}, or
  \code{all.coef = FALSE}, a numeric vector of predicted values. Otherwise, a matrix of
  predicted values, with one column per value of \code{lambda}.
}
\references{
     A semi-automatic method to guide the choice of ridge parameter in
     ridge regression. Cule, E. and De Iorio, M.  (2012)
     arXiv:1205.0686v1
}
\author{
	Erika Cule
}

\seealso{
  \code{\link{linearRidge}}
}
\examples{
     data(GenCont)
     mod <- linearRidge(Phenotypes ~ ., data = as.data.frame(GenCont))
     predict(mod)
}
