\name{predict.ridgeLogistic}
\alias{predict.ridgeLogistic}

\title{
  Predict method for \code{logisticRidge} model fits.
}
\description{
  Predicted values based on a \code{ridgeLogistic} model object.
}

\usage{
\method{predict}{ridgeLogistic}(object, newdata = NULL, type = c("link","response"),
    na.action = na.pass, all.coef = FALSE, ...)
}

\arguments{
  \item{object}{
    Object of class \code{ridgeLogistic}, typically generated by a call
  to \code{logisticRidge}.
}
  \item{newdata}{
    An optional data frame in which to look for variables with which to
  predict. If omitted, the fitted values are used.
}
  \item{type}{
    One of \code{"link"} (the default) or
    \code{"response"}. \code{"link"} returns the probabilities on the
    logit scale, and \code{"response"} returns the fitted probabilities.
  }
  \item{na.action}{
    Function determining what should be done with missing values
    in \code{newdata}.  The default is to predict \code{NA}.
  }
  \item{all.coef}{
    Logical. Should results be returned for all ridge regression
    penalty parameters (\code{all.coef = TRUE}), or only for the ridge
    parameter chosen automatically?
  }
  \item{\dots}{
    Additional arguments to be passed to or from other methods.
  }
}
\details{
  \code{predict.ridgeLogistic} produces predicted values, obtained by
  evaluating the regression function in the frame \code{newdata} (which
  defaults to \code{model.frame(object)}).

  If \code{newdata} is omitted the predictions are based on the data used
  for the fit.
}
\value{
  Depends on the call to \code{logisticRidge} used to generate
  \code{object}. If \code{logisticRidge} was called with only one value of \code{lambda}, or
  \code{all.coef = FALSE}, a numeric vector of predicted values. Otherwise, a matrix of
  predicted values, with one column per value of \code{lambda}.
}
\references{
     A semi-automatic method to guide the choice of ridge parameter in
     ridge regression. Cule, E. and De Iorio, M.  (2012)
     arXiv:1205.0686v1
}
\author{
	Erika Cule
}

\seealso{
  \code{\link{logisticRidge}}
}
\examples{
data(GenBin)
mod <- logisticRidge(Phenotypes ~ ., data = as.data.frame(GenBin))
predict(mod)
}

