% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/idig_top_media.R
\name{idig_top_media}
\alias{idig_top_media}
\title{Top media endpoint}
\usage{
idig_top_media(rq = FALSE, mq = FALSE, top_fields = FALSE, count = 0,
  ...)
}
\arguments{
\item{rq}{iDigBio record query in nested list format}

\item{mq}{iDigBio media query in nested list format}

\item{top_fields}{vector of field names to summarize by}

\item{count}{maximum number of results to return, capped at 1000}

\item{...}{additional parameters}
}
\value{
nested list of field values with counts of media records
}
\description{
Top media records summaries.
}
\details{
Summarize the count of media records in iDigBio according to unique values
in the fields passed. This operates similarly to a SELECT DISTINCT count(
field_name) query in SQL. When multiple fields are passed, the summaries are
nested eg fields=c("country", "genus") would result in counting the top 10
genera in each of the top 10 countries for a total of 100 counts.
}
\author{
Matthew Collins
}

