% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/federation_data.R
\name{federation_data}
\alias{federation_data}
\title{Federation data}
\usage{
federation_data(id, query = NULL, strict = FALSE, subclassQuery = NULL,
  expandSynonyms = TRUE, expandAcronyms = FALSE, expandAbbrevs = FALSE,
  expandInferred = TRUE, highlight = FALSE, sortField = NULL,
  sortAsc = TRUE, offset = 0, count = 20, project = NULL,
  facet = NULL, filter = NULL, subclassFilter = NULL,
  includePrimaryData = FALSE, exportType = NULL, orMultiFacets = FALSE,
  key = NULL, ...)
}
\arguments{
\item{id}{(character) A dataset id}

\item{query}{Query terms}

\item{strict}{(logical) Only consider more relevant columns.
Default: \code{FALSE}}

\item{subclassQuery}{(character) An known ID to query with subclass
axiom entailment (include all subclasses in the search). This can be
combined with the "query" parameter.}

\item{expandSynonyms}{(logical) Should recognized terms in the query have
synonyms expanded? Default: \code{TRUE}}

\item{expandAcronyms}{(logical) Default: \code{FALSE}}

\item{expandAbbrevs}{(logical) Default: \code{FALSE}}

\item{expandInferred}{(logical) Should recognized terms in the query have
inferred terms expanded? Default: \code{TRUE}}

\item{highlight}{(logical) Highlight ...}

\item{sortField}{(character) The field to sort by}

\item{sortAsc}{(logical) Sort ascending?}

\item{offset}{(integer) The result (row) to start on}

\item{count}{(integer) The number of results (rows) to return}

\item{project}{(character) The columns to project (all by default)}

\item{facet}{(character) Facets specified like facetName:facetValue}

\item{filter}{(character) Filters specified like columnName:filterValue.
If the column is declared numeric then the filterValue can be a range
expression (ie: >24.3).}

\item{subclassFilter}{(character) Filter specified like columnName:parentId
where parentId is a known ID. All subclasses of parentID will be included
in the filter. This parameter may be combined with "filter".}

\item{includePrimaryData}{(logical) deprecated Should primary data be
included in addition to the view? Please use the exportType option instead.}

\item{exportType}{(character) The type of data to return: "display" (data
suitable for a user interface - includes HTML), "data" (just the raw data
used to include the view - may include more data than present in the view
but will not include markup) "all" (include both display and data columns)}

\item{orMultiFacets}{(logical) True if multiple facet values for the same
facet are specified in the query and should be ORed together. Defaults to
"AND"}

\item{key}{(character) API key. required either passed in here or save
as an env var or R option. see \code{\link{rif}} and \code{\link{Startup}}}

\item{...}{Curl options passed on to \code{\link[crul]{HttpClient}}}
}
\description{
Federation data
}
\examples{
\dontrun{
out <- federation_data(id = "nlx_152871-2")
out$query
out$messages
out$result$resultCount
out$result$nifId
out$result$debugInfo
out$result$result
out$result$results

federation_data(id = "nlx_152871-2", query = "TS23")

federation_data("nlx_152871-2", verbose = TRUE)
}
}
\seealso{
Other federation: \code{\link{federation_facet}},
  \code{\link{federation_search}}
}
