% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress_diagnostics.R
\name{residuals.uRegress}
\alias{residuals.uRegress}
\alias{residuals}
\title{Extract Residuals from \code{uRegress} objects}
\usage{
\method{residuals}{uRegress}(object, type = "", ...)
}
\arguments{
\item{object}{an object of class \code{uRegress}, as returned by
\link[rigr]{regress}.}

\item{type}{denotes the type of residuals to return. Default value is
\code{""}, which returns unstandardized residuals. \code{"standardized"},
\code{"studentized"}, and \code{"jackknife"} return the expected type of
residuals.}

\item{...}{other arguments}
}
\value{
Returns the type of residuals
requested.
}
\description{
Extracts residuals (unstandardized, standardized, studentized, or jackknife)
from \code{uRegress} objects.
}
\details{
Relies on
functionality from the \code{stats} package to return residuals from the
\code{uRegress} object. \code{"studentized"} residuals are computed as
internally studentized residuals, while \code{"jackknife"} computes the
externally studentized residuals.
}
\examples{

# Reading in a dataset
data(mri)

# Create a uRegress object, regressing ldl on age
ldlReg <- regress("mean", age~ldl, data=mri)

# Get the studentized residuals
residuals(ldlReg, "studentized")

# Get the jackknifed residuals
residuals(ldlReg, "jackknife")

}
\seealso{
\code{\link[rigr]{regress}}, \code{\link[stats]{rstudent}},
\code{\link[stats]{rstandard}}
}
