% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quote.R
\name{riingo_crypto_quote}
\alias{riingo_crypto_quote}
\title{Quote and Top of Book data for a given cryptocurrency}
\usage{
riingo_crypto_quote(
  ticker,
  exchanges = NULL,
  convert_currency = NULL,
  raw = FALSE
)
}
\arguments{
\item{ticker}{One or more cryptocurrency tickers.
Specified as \code{"btcusd"} for bitcoin quoted in USD. A character vector.}

\item{exchanges}{If you would like to limit the query to a subset of exchanges,
pass a comma-separated list of exchanges to select. Example) \code{"POLONIEX, GDAX"}}

\item{convert_currency}{This parameter will convert the return data into another
fx rate. For example if querying \code{BTCUSD} and convert_currency is \code{'cure'},
the bitcoin prices will be converted to CureCoin prices.
Setting this to a value will add \code{fxOpen}, \code{fxHigh}, \code{fxLow}, \code{fxClose}, \code{fxVolumeNotional},
and \code{fxRate} accordingly. \code{fxRate} is the rate used to perform the currency calculation.
If \code{exchanges} is specified, the conversion rate will be calculated using the exchanges passed.}

\item{raw}{If \code{TRUE}, the raw underlying data from multiple exchanges will be
returned, rather than the clean prices. This is the data that calculates the aggregated prices and quotes.}
}
\description{
Tiingo provides TOP (top of book) bid and ask quotes for cryptocurrencies.
Note that this cannot be historically queried.
}
\details{
At the end of the day, the, \code{askPrice}, \code{bidSize}, \code{bidPrice}, \code{askSize},
and \code{lastSize} fields may be \code{NA}. This is normal.
}
\examples{

\dontrun{

riingo_crypto_quote("btcusd")

# The raw data can provide more insight into each individual exchange
riingo_crypto_quote("btcusd", raw = TRUE)

}

}
