# rim 0.5.1
## Minor
- `knitr`-engine now supports chunk options `echo`, `eval` and `include`, a description can be found in the documentation page
- fixed several issues related to changes with Maxima version 5.46.0

# rim 0.5.0
## Minor
- `knitr`-engine now supports plotting commands: plot2d(), plot3d(), draw(), draw2d(), draw3d() (and others that are based on those mentioned), depending on the output format (PDF or HTML), plots are saved as PDF or PNG respectively
- Added inline output function to be used when knitting `RMarkdown` documents.
- Restructured the return type of the get function: Instead of a character string, now a list is returned storing every output format of the result including both with and without reference labels.
- Added a global option handling function `maxima.options()` and removed individual option setting functions `maxima.setformat()`, `maxima.engine.format()` and friends
- Whether reference labels are printed or not when knitting a `RMarkdown` document can now be controlled by setting `maxima.options(engine.label)`

## Modifications
- Removed some unused utility functions from code
- Removed unnecessary C++17 compiler flag
- Improved documentation
- Updated heuristics for catching warnings and errors
- Improved typesetting of output labels when knitting `RMarkdown` documents 
- Improved warning/ error handling heuristics (fixing issue #20)

# rim 0.4.1
## Modifications
- fixed issue #16. code chunks that contain commands spanning multiple lines are now printed as-is (except for empty lines, which are removed) with the preceding input reference label 
- fixed the issue #17, caused by a socket-read-write-concurrency conflict which led to split lines read from Maxima and a failure to validate it's output. This is achieved now by an internal helper R6 class `MReader` that stashes away incomplete lines and completes it upon re-calling.
- fixed reference manual that is generated by CRAN, but previously did not contain the package main functions
- Improved description in `DESCRIPTION` of `SystemRequirements`
- added exported function `maxima.isInstalled()` that is now used upon package attachment, where a message is signaled to install Maxima, if no installation was found.
- added exported function `maxima.version()` which is now used upon package attachment, where a message is signaled when the installed version is lower than the version with which this package has been tested
- Test file `tests/testthat/test-engine.R`: knitting test page now suppresses Warnings, which are subject of `tests/testthat/test-warnings.R` 

# rmaxima 0.4.0/ rim 0.4.0
- added `maxima.engine.format()` function that can be used to change the output format of the `knitr` engine
- fixed issue that arises when Maxima takes longer to start (which previously caused the interface to freeze)
- added functions to record the version number of Maxima that is being used
- renamed package to "rim" to avoid confusion with `maxima`'s `rmaxima`
- communication is now implemented using sockets and the processing is handles by two nested R6 classes
- return type is now a S3 class of type maxima. There are two methods `iprint()` and `oprint()` for printing an maxima S3 object: printing the input command and output respectively, including reference labels. 
- removed external C++ library dependencies (now using sockets for communicating with Maxima)
- `knitr` engine now prints output after each input line, it also prints the input reference label in front of the command

# rmaxima 0.0.0.9000

- removed dependency from boost (switched to libexecstream)
- maxima.get() returns character vector with added attributes for reference labels, format and it's originating command
- fixed Maxima error (message) forwarding to R
- implement `knitr`-engine for maxima using this interface
- Implement stop function to end maxima child process for debugging purposes
- Handles `asksign` and similar feedback interruptions
- Added interface to maxima's apropos()-function
- Fixed: If command terminates with `\$` then this causes a segmentation fault, which kills the R process. The cause being that maxima returns immediately with the next input prompt
- added `roxygen2` documentation
- fixed `system.file` call inside constructor to work with `devtools::load_all()`
- Added a `NEWS.md` file to track changes to the package.
- Add test files
- implemented output display as `tex` (not yet user-friendly)
- added initialization files
- added function void `loadModule(const std::string &s)`
- Removed boost::regex linking dependency
- fixed pipe stream synchronization
