% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropyrate.R
\name{entropy_rate}
\alias{entropy_rate}
\title{Entropy Rate}
\usage{
entropy_rate(series, k, local = FALSE)
}
\arguments{
\item{series}{Vector or matrix specifying one or more time series.}

\item{k}{Integer giving the history length.}

\item{local}{Boolean specifying whether to compute the local entropy rate.}
}
\value{
Numeric giving the average entropy rate or a vector giving the
        local entropy rate.
}
\description{
Compute the average or local entropy rate of a time series with history
length \code{k}.
}
\examples{
# The typical usage is to provide the time series and the history length. 
xs <- c(0, 0, 1, 1, 1, 1, 0, 0, 0)
entropy_rate(xs, k = 2) #0.6792696
# [1] 1.0, 0.0, 0.5849625, 0.5849625, 1.5849625, 0.0, 1.0
entropy_rate(xs, k = 2, local = TRUE)

# Multiple Initial Conditions
xs      <- matrix(0, nrow = 9, ncol = 2)
xs[, 1] <- c(0, 0, 1, 1, 1, 1, 0, 0, 0)
xs[, 2] <- c(1, 0, 0, 1, 0, 0, 1, 0, 0)
entropy_rate(xs, k = 2)         # 0.6253491

# [, 1] 0.4150375, 1.5849625, 0.5849625, 0.5849625, 1.5849625, 0.0, 2.0
# [, 2] 0.0, 0.4150375, 0.5849625, 0.0, 0.4150375, 0.5849625, 0.0
entropy_rate(xs, k = 2, local = TRUE)
}
