% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{caldist}
\alias{caldist}
\title{Calculate calibrated distribution}
\usage{
caldist(
  age,
  error,
  cc = 1,
  postbomb = FALSE,
  yrsteps = FALSE,
  threshold = 0.001,
  normal = TRUE,
  t.a = 3,
  t.b = 4,
  BCAD = FALSE,
  rule = 1,
  ccdir = NULL
)
}
\arguments{
\item{age}{Uncalibrated radiocarbon age}

\item{error}{Lab error of the radiocarbon age}

\item{cc}{Calibration curve to use. Defaults to IntCal20 (\code{cc=1}).}

\item{postbomb}{Whether or not to use a postbomb curve. Required for negative radiocarbon ages.}

\item{yrsteps}{Steps to use for interpolation. Defaults to the cal BP steps in the calibration curve}

\item{threshold}{Report only values above a threshold. Defaults to \code{threshold=1e-6}.}

\item{normal}{Use the normal distribution to calibrate dates (default TRUE). The alternative is to use the t model (Christen and Perez 2016).}

\item{t.a}{Value a of the t distribution (defaults to 3).}

\item{t.b}{Value a of the t distribution (defaults to 4).}

\item{BCAD}{Which calendar scale to use. Defaults to cal BP, \code{BCAD=FALSE}.}

\item{rule}{Which extrapolation rule to use. Defaults to \code{rule=1} which returns NAs.}

\item{ccdir}{Directory of the calibration curves. Defaults to where the package's files are stored (system.file), but can be set to, e.g., \code{ccdir="curves"}.}
}
\value{
The probability distribution(s) as two columns: cal BP ages and their associated probabilities
}
\description{
Calculate the calibrated distribution of a radiocarbon date.
}
\examples{
calib <- caldist(130,20)
plot(calib, type="l")
postbomb <- caldist(-3030, 20, "nh1", BCAD=TRUE)
}
