% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transformCIBP}
\alias{transformCIBP}
\title{Compute Confidence Intervals/Bands and P-values After a Transformation}
\usage{
transformCIBP(estimate, se, iid, null, conf.level, nsim.band, seed, type,
  min.value, max.value, ci, band, p.value)
}
\arguments{
\item{estimate}{[numeric matrix] the estimate value before transformation.}

\item{se}{[numeric matrix] the standard error before transformation.}

\item{iid}{[numeric array] the standard error before transformation.}

\item{null}{[numeric] the value of the estimate (before transformation) under the null hypothesis.}

\item{conf.level}{[numeric, 0-1] Level of confidence.}

\item{nsim.band}{[integer, >0] the number of simulations used to compute the quantiles for the confidence bands.}

\item{seed}{[integer, >0] seed number set before performing simulations for the confidence bands.}

\item{type}{[character] the transforamtion.
Can be \code{"log"}, \code{"loglog"}, \code{"cloglog"}, or \code{"atanh"} (Fisher transform).}

\item{min.value}{[numeric] if not \code{NULL} and the lower bound of the confidence interval is below \code{min},
it will be set at \code{min}.}

\item{max.value}{[numeric] if not \code{NULL} and the lower bound of the confidence interval is below \code{max},
it will be set at \code{max}.}

\item{ci}{[logical] should confidence intervals be computed.}

\item{band}{[logical] should confidence bands be computed.}

\item{p.value}{[logical] should p-values be computed.

The iid decomposition must have dimensions [n.prediction,time,n.obs]
while estimate and se must have dimensions [n.prediction,time].}
}
\description{
Compute confidence intervals/bands and p-values after a transformation
}
