% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_risk_mod.R
\name{cv_risk_mod}
\alias{cv_risk_mod}
\title{Run Cross-Validation to Tune Lambda0}
\usage{
cv_risk_mod(
  X,
  y,
  weights = NULL,
  beta = NULL,
  a = -10,
  b = 10,
  max_iters = 10000,
  tol = 1e-05,
  nlambda = 25,
  lambda_min_ratio = ifelse(nrow(X) < ncol(X), 0.01, 1e-04),
  lambda0 = NULL,
  nfolds = 10,
  foldids = NULL,
  parallel = FALSE,
  shuffle = TRUE,
  seed = NULL,
  method = "annealscore"
)
}
\arguments{
\item{X}{Input covariate matrix with dimension \eqn{n \times p};
every row is an observation.}

\item{y}{Numeric vector for the (binomial) response variable.}

\item{weights}{Numeric vector of length \eqn{n} with weights for each
observation. Unless otherwise specified, default will give equal weight to
each observation.}

\item{beta}{Starting numeric vector with \eqn{p} coefficients.
Default starting coefficients are rounded coefficients from a
logistic regression model.}

\item{a}{Integer lower bound for coefficients (default: -10).}

\item{b}{Integer upper bound for coefficients (default: 10).}

\item{max_iters}{Maximum number of iterations (default: 10000).}

\item{tol}{Tolerance for convergence (default: 1e-5).}

\item{nlambda}{Number of lambda values to try (default: 25).}

\item{lambda_min_ratio}{Smallest value for lambda, as a fraction of
lambda_max (the smallest value for which all coefficients are zero).
The default depends on the sample size (\eqn{n}) relative to the number of
variables (\eqn{p}). If \eqn{n > p}, the default is 0.0001, close to zero.
If \eqn{n < p}, the default is 0.01.}

\item{lambda0}{Optional sequence of lambda values. By default, the function
will derive the lambda0 sequence based on the data (see \code{lambda_min_ratio}).}

\item{nfolds}{Number of folds, implied if \code{foldids} provided (default: 10).}

\item{foldids}{Optional vector of values between 1 and \code{nfolds}.}

\item{parallel}{If \code{TRUE}, parallel processing (using \link[foreach:foreach]{foreach})
is implemented during cross-validation to increase efficiency
(default: \code{FALSE}). User must first register parallel backend with
a function such as \link[doParallel:registerDoParallel]{registerDoParallel}.}

\item{shuffle}{Whether order of coefficients is shuffled during coordinate
descent (default: TRUE).}

\item{seed}{An integer that is used as argument by \code{set.seed()} for
offsetting the random number generator. Default is to not set a
particular randomization seed.}

\item{method}{A string that specifies which method ("riskcd" or "annealscore")
to run (default: "annealscore")}
}
\value{
An object of class "cv_risk_mod" with the following attributes:
\item{results}{Dataframe containing a summary of deviance, accuracy, and auc for
each value of \code{lambda0} (mean and SD). Also includes the number of nonzero
coefficients that are produced by each \code{lambda0} when fit on the full data.}
\item{lambda_min}{Numeric value indicating the \code{lambda0} that resulted in the
highest mean auc}
\item{lambda_1se}{Numeric value indicating the largest \code{lamdba0} that
had a mean auc within one standard error of \code{lambda_min}.}
}
\description{
Runs k-fold cross-validation on a grid of \eqn{\lambda_0} values. Records
class accuracy and deviance for each \eqn{\lambda_0}. Returns an object of
class "cv_risk_mod".
}
