% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_txt.R
\docType{data}
\name{txt}
\alias{txt}
\title{Basic text elements.}
\format{An object of class \code{list} of length 21.}
\usage{
txt
}
\description{
\code{txt} is initialized to a list of named elements
to define basic scenario titles and labels.
}
\details{
All textual elements that specify generic labels and titles of \code{riskyr} scenarios
are stored as named elements (of type character) in a list \code{txt}.
To change an element, assign a new character object to an existing name.

The list \code{txt} is used throughout the \code{riskyr} package
unless a scenario defines scenario-specific text labels
(when using the \code{\link{riskyr}} function).

Note:

\itemize{

\item Basic text information and some numeric parameters
  (see \code{\link{num}} and \code{\link{init_num}})
  are integral parts of a \code{riskyr} scenario.

\item By contrast, basic \emph{color} information
  (see \code{\link{pal}} and \code{\link{init_pal}})
  is not an integral part, but independently defined.

\item The names of \emph{probabilities}
  (see \code{\link{prob}}) are currently
  not an integral part of \code{txt} and \code{riskyr} scenarios
  (but defined in \code{prob_lbl_def} and \code{label_prob}).
}

\code{txt} currently contains the following text labels:

\enumerate{

\item \code{scen_lbl} The current scenario title (sometimes in Title Caps).

\item \code{scen_txt} A longer text description of the current scenario
(which may extend over several lines).

\item \code{scen_src} The source information for the current scenario.

\item \code{scen_apa} The source information in APA format.

\item \code{scen_lng} The language of the current scenario (as character code).
Options: \code{"en"}: English, \code{"de"}: German.

\item \code{popu_lbl} A general name describing the current \emph{population}.

\item \code{N_lbl} A short label for the current population \code{\link{popu}} or sample.

\item \code{cond_lbl} A general name for the \emph{condition} dimension,
or the feature (e.g., some disease) currently considered.

\item \code{cond_true_lbl} A short label for the \emph{presence} of the current condition
or \code{\link{cond_true}} cases (the condition's true state of being TRUE).

\item \code{cond_false_lbl} A short label for the \emph{absence} of the current condition
or \code{\link{cond_false}} cases (the condition's true state of being FALSE).

\item \code{dec_lbl} A general name for the \emph{decision} dimension,
or the judgment (e.g., some diagnostic test) currently made.

\item \code{dec_pos_lbl} A short label for \emph{positive} decisions
or \code{\link{dec_pos}} cases (e.g., predicting the presence of the condition).

\item \code{dec_neg_lbl} A short label for \emph{negative} decisions
or \code{\link{dec_neg}} cases (e.g., predicting the absence of the condition).

\item \code{acc_lbl} A general name for the \emph{accuracy} dimension,
or the correspondence between the condition currently considered
and the decision judgment currently made.

\item \code{dec_cor_lbl} A short label for \emph{correct} and \emph{accurate} decisions
or \code{\link{dec_cor}} cases (accurate predictions).

\item \code{dec_err_lbl} A short label for \emph{incorrect} decisions
or \code{\link{dec_err}} cases (erroneous predictions).

\item \code{sdt_lbl} A general name for all 4 \emph{cases/categories/cells}
of the 2x2 contingency table (e.g., condition x decision, using SDT).

\item \code{hi_lbl} A short label for \emph{hits} or \emph{true positives} \code{\link{hi}}/TP cases
(i.e., correct decisions of the presence of the condition, when the condition is actually present).

\item \code{mi_lbl} A short label for \emph{misses} or \emph{false negatives} \code{\link{mi}}/FN cases
(i.e., incorrect decisions of the absence of the condition when the condition is actually present).

\item \code{fa_lbl} A short label for \emph{false alarms} or \emph{false positives} \code{\link{fa}}/FP cases
(i.e., incorrect decisions of the presence of the condition when the condition is actually absent).

\item \code{cr_lbl} A short label for \emph{correct rejections} or \emph{true negatives} \code{\link{cr}}/TN cases
(i.e., a correct decision of the absence of the condition, when the condition is actually absent).

}
}
\examples{
txt           # Show  all current names and elements
txt$scen_lbl  # Show the current scenario label (e.g., used in plot titles)
txt$scen_lbl <- "My example"  # Set a new scenario title

}
\seealso{
\code{\link{init_txt}} initializes text information;
\code{\link{riskyr}} initializes a \code{riskyr} scenario;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{pal}} contains current color information;
\code{\link{init_pal}} initializes color information;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information.

Other lists containing current scenario information: \code{\link{accu}},
  \code{\link{freq}}, \code{\link{num}},
  \code{\link{pal_bw}}, \code{\link{pal_kn}},
  \code{\link{pal_mbw}}, \code{\link{pal_mod}},
  \code{\link{pal_org}}, \code{\link{pal_rgb}},
  \code{\link{pal_vir}}, \code{\link{pal}},
  \code{\link{prob}}, \code{\link{txt_TF}},
  \code{\link{txt_org}}
}
\concept{lists containing current scenario information}
\keyword{datasets}
