% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_prob.R
\docType{data}
\name{FOR}
\alias{FOR}
\title{The false omission rate (FOR) of a decision process or diagnostic procedure.}
\format{
An object of class \code{numeric} of length 1.
}
\usage{
FOR
}
\description{
\code{FOR} defines a decision's false omission rate (\code{FOR}):
The conditional probability of the condition being \code{TRUE}
provided that the decision is negative.
}
\details{
Understanding or obtaining the false omission rate \code{FOR}:

\itemize{

  \item Definition:
  \code{FOR} is the so-called false omission rate:
  The conditional probability for the condition being \code{TRUE}
  given a negative decision:

  \code{FOR = p(condition = TRUE | decision = negative)}

  \item Perspective:
  \code{FOR} further classifies
  the subset of \code{\link{dec_neg}} individuals
  by condition (\code{FOR = mi/dec_neg = mi/(mi + cr)}).

  \item Alternative names:
  none?

  \item Relationships:

  a. \code{FOR} is the complement of the
  negative predictive value \code{\link{NPV}}:

  \code{FOR = 1 - NPV}

  b. \code{FOR} is the opposite conditional probability
  -- but not the complement --
  of the miss rate \code{\link{mirt}}
  (aka. false negative rate \code{FDR}):

  \code{mirt = p(decision = negative | condition = TRUE)}

  \item In terms of frequencies,
  \code{FOR} is the ratio of
  \code{\link{mi}} divided by \code{\link{dec_neg}}
  (i.e., \code{\link{mi} + \link{cr}}):

  \code{NPV = mi/dec_neg = mi/(mi + cr)}

  \item Dependencies:
  \code{FOR} is a feature of a decision process
  or diagnostic procedure and a measure of incorrect
  decisions (negative decisions that are actually \code{FALSE}).

  However, due to being a conditional probability,
  the value of \code{FOR} is not intrinsic to
  the decision process, but also depends on the
  condition's prevalence value \code{\link{prev}}.

}
}
\examples{
FOR <- .05     # sets a false omission rate of 5\%
FOR <- 5/100   # (condition = TRUE) for 5 out of 100 people with (decision = negative)
is_prob(FOR)   # TRUE

}
\references{
Consult \href{https://en.wikipedia.org/wiki/Positive_and_negative_predictive_values}{Wikipedia} for additional information.
}
\seealso{
\code{\link{comp_FOR}} computes \code{FOR} as the complement of \code{\link{NPV}};
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{is_prob}} verifies probabilities.

Other probabilities: 
\code{\link{FDR}},
\code{\link{NPV}},
\code{\link{PPV}},
\code{\link{acc}},
\code{\link{err}},
\code{\link{fart}},
\code{\link{mirt}},
\code{\link{ppod}},
\code{\link{prev}},
\code{\link{sens}},
\code{\link{spec}}
}
\concept{probabilities}
\keyword{datasets}
