% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortestroute_cleanup.R
\name{removemicrosegs}
\alias{removemicrosegs}
\title{Remove Segments that are Smaller than the Connectivity Tolerance}
\usage{
removemicrosegs(rivers)
}
\arguments{
\item{rivers}{The river network object to use.}
}
\value{
A new river network object with the specified segments connected (see \link{rivernetwork})
}
\description{
Automatically detects and removes segments with total displacement (straight-line distance between endpoints) less than the connectivity tolerance.  These segments do not serve any real purpose, are bypassed in routes, and cannot be dissolved.
}
\note{
This function is called within \link{cleanup}, which is recommended in most cases.
}
\examples{
data(abstreams0)
abstreams1 <- removemicrosegs(abstreams0)
}
\author{
Matt Tyers
}
\seealso{
line2network
}

