% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_ts.R
\name{set_ts}
\alias{set_ts}
\title{Change the input time series of a SaItem}
\usage{
set_ts(sa_item, ts)
}
\arguments{
\item{sa_item}{the \code{sa_item} to modify.}

\item{ts}{the new \code{\link[stats:ts]{stats::ts()}} object.}
}
\value{
a \code{sa_item}
}
\description{
Function to change the input time series of a SaItem
}
\examples{

library("RJDemetra")

# Definition of the original time series
sa_x13 <- jx13(series = ipi_c_eu[, "FR"])

wk <- new_workspace()
sap1 <- new_multiprocessing(workspace = wk, name = "sap-1")

# Adding a new SA-Item (`sa_x13`) to `sap1`
add_sa_item(workspace = wk, multiprocessing = "sap-1",
            sa_obj = sa_x13, name = "X13")

# Retrieving the adjusted series
sa_item1 <- get_object(x = sap1, pos = 1L)

# Creation of a new sa_item and change of the input time series
new_sa_item <- set_ts(sa_item = sa_item1, ts = ipi_c_eu[, "BE"])
# Replacement of the series in the workspace
replace_sa_item(sap = sap1, pos = 1L, sa_item = new_sa_item)

}
