/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import kafka.api.FetchResponsePartitionData;
import kafka.api.OffsetResponse;
import kafka.cluster.Broker;
import kafka.common.TopicAndPartition;
import kafka.tools.ReplicaBuffer$;
import kafka.tools.ReplicaBuffer$$anonfun$kafka$tools$ReplicaBuffer$;
import kafka.tools.ReplicaVerificationTool$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.SystemTime$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001C\u0001\u0003\t\u0003\u0005\t\u0011B\u0004\u0003\u001bI+\u0007\u000f\\5dC\n+hMZ3s\u0015\t\u0019A!A\u0003u_>d7OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u0011-A\u0011\u0011BD\u0007\u0002\u0015)\u00111\u0002D\u0001\u0005Y\u0006twMC\u0001\u000e\u0003\u0011Q\u0017M^1\n\u0005=Q!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\t\u0005)Q\u000f^5mg&\u0011QC\u0005\u0002\b\u0019><w-\u001b8h!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011u\u0001!\u0011!Q\u0001\ny\tA%\u001a=qK\u000e$X\r\u001a*fa2L7-Y:QKJ$v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\t\u0005?\t*3F\u0004\u0002\u0018A%\u0011\u0011\u0005G\u0001\u0007!J,G-\u001a4\n\u0005\r\"#aA'ba*\u0011\u0011\u0005\u0007\t\u0003M%j\u0011a\n\u0006\u0003Q\u0011\taaY8n[>t\u0017B\u0001\u0016(\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\t\u0003/1J!!\f\r\u0003\u0007%sG\u000f\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0003AaW-\u00193feN\u0004VM\u001d\"s_.,'\u000f\u0005\u0003 E-\n\u0004c\u0001\u001a;K9\u00111\u0007\u000f\b\u0003i]j\u0011!\u000e\u0006\u0003m\u0019\ta\u0001\u0010:p_Rt\u0014\"A\r\n\u0005eB\u0012a\u00029bG.\fw-Z\u0005\u0003wq\u00121aU3r\u0015\tI\u0004\u0004\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003,\u0003M)\u0007\u0010]3di\u0016$g*^7GKR\u001c\u0007.\u001a:t\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0015!\u00032s_.,'/T1q!\u0011y\"e\u000b\"\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015#\u0011aB2mkN$XM]\u0005\u0003\u000f\u0012\u0013aA\u0011:pW\u0016\u0014\b\u0002C%\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\u0002#%t\u0017\u000e^5bY>3gm]3u)&lW\r\u0005\u0002\u0018\u0017&\u0011A\n\u0007\u0002\u0005\u0019>tw\r\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003K\u00039\u0011X\r]8si&sG/\u001a:wC2DQ\u0001\u0015\u0001\u0005\u0002E\u000ba\u0001P5oSRtDc\u0002*U+Z;\u0006,\u0017\t\u0003'\u0002i\u0011A\u0001\u0005\u0006;=\u0003\rA\b\u0005\u0006_=\u0003\r\u0001\r\u0005\u0006}=\u0003\ra\u000b\u0005\u0006\u0001>\u0003\r!\u0011\u0005\u0006\u0013>\u0003\rA\u0013\u0005\u0006\u001d>\u0003\rA\u0013\u0005\b7\u0002\u0011\r\u0011\"\u0003]\u000391W\r^2i\u001f\u001a47/\u001a;NCB,\u0012!\u0018\t\u0005#y+#*\u0003\u0002`%\t!\u0001k\\8m\u0011\u0019\t\u0007\u0001)A\u0005;\u0006ya-\u001a;dQ>3gm]3u\u001b\u0006\u0004\b\u0005C\u0004d\u0001\t\u0007I\u0011\u00023\u0002\u001f5,7o]1hKN+GoQ1dQ\u0016,\u0012!\u001a\t\u0005#y+c\r\u0005\u0003\u0012=.:\u0007C\u00015l\u001b\u0005I'B\u00016\u0005\u0003\r\t\u0007/[\u0005\u0003Y&\u0014!DR3uG\"\u0014Vm\u001d9p]N,\u0007+\u0019:uSRLwN\u001c#bi\u0006DaA\u001c\u0001!\u0002\u0013)\u0017\u0001E7fgN\fw-Z*fi\u000e\u000b7\r[3!\u0011\u001d\u0001\bA1A\u0005\nE\faBZ3uG\",'OQ1se&,'/F\u0001s!\r\u0019(\u0010`\u0007\u0002i*\u0011QO^\u0001\u0007CR|W.[2\u000b\u0005]D\u0018AC2p]\u000e,(O]3oi*\u0011\u0011\u0010D\u0001\u0005kRLG.\u0003\u0002|i\ny\u0011\t^8nS\u000e\u0014VMZ3sK:\u001cW\r\u0005\u0002~}6\ta/\u0003\u0002\u0000m\nq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0007bBA\u0002\u0001\u0001\u0006IA]\u0001\u0010M\u0016$8\r[3s\u0005\u0006\u0014(/[3sA!A\u0011q\u0001\u0001C\u0002\u0013%\u0011/A\nwKJLg-[2bi&|gNQ1se&,'\u000fC\u0004\u0002\f\u0001\u0001\u000b\u0011\u0002:\u0002)Y,'/\u001b4jG\u0006$\u0018n\u001c8CCJ\u0014\u0018.\u001a:!\u0011%\ty\u0001\u0001a\u0001\n\u0013\t\t\"\u0001\bmCN$(+\u001a9peR$\u0016.\\3\u0016\u0003)C\u0011\"!\u0006\u0001\u0001\u0004%I!a\u0006\u0002%1\f7\u000f\u001e*fa>\u0014H\u000fV5nK~#S-\u001d\u000b\u0005\u00033\ty\u0002E\u0002\u0018\u00037I1!!\b\u0019\u0005\u0011)f.\u001b;\t\u0013\u0005\u0005\u00121CA\u0001\u0002\u0004Q\u0015a\u0001=%c!9\u0011Q\u0005\u0001!B\u0013Q\u0015a\u00047bgR\u0014V\r]8siRKW.\u001a\u0011)\t\u0005\r\u0012\u0011\u0006\t\u0004/\u0005-\u0012bAA\u00171\tAao\u001c7bi&dW\rC\u0005\u00022\u0001\u0001\r\u0011\"\u0003\u0002\u0012\u00051Q.\u0019=MC\u001eD\u0011\"!\u000e\u0001\u0001\u0004%I!a\u000e\u0002\u00155\f\u0007\u0010T1h?\u0012*\u0017\u000f\u0006\u0003\u0002\u001a\u0005e\u0002\"CA\u0011\u0003g\t\t\u00111\u0001K\u0011\u001d\ti\u0004\u0001Q!\n)\u000bq!\\1y\u0019\u0006<\u0007\u0005C\u0005\u0002B\u0001\u0001\r\u0011\"\u0003\u0002\u0012\u0005\u0001rN\u001a4tKR<\u0016\u000e\u001e5NCbd\u0015m\u001a\u0005\n\u0003\u000b\u0002\u0001\u0019!C\u0005\u0003\u000f\nAc\u001c4gg\u0016$x+\u001b;i\u001b\u0006DH*Y4`I\u0015\fH\u0003BA\r\u0003\u0013B\u0011\"!\t\u0002D\u0005\u0005\t\u0019\u0001&\t\u000f\u00055\u0003\u0001)Q\u0005\u0015\u0006\trN\u001a4tKR<\u0016\u000e\u001e5NCbd\u0015m\u001a\u0011\t\u0013\u0005E\u0003\u00011A\u0005\n\u0005M\u0013aF7bq2\u000bw\rV8qS\u000e\fe\u000e\u001a)beRLG/[8o+\u0005)\u0003\"CA,\u0001\u0001\u0007I\u0011BA-\u0003mi\u0017\r\u001f'bOR{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|gn\u0018\u0013fcR!\u0011\u0011DA.\u0011%\t\t#!\u0016\u0002\u0002\u0003\u0007Q\u0005C\u0004\u0002`\u0001\u0001\u000b\u0015B\u0013\u000215\f\u0007\u0010T1h)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007\u0005C\u0004\u0002d\u0001!\t!!\u001a\u0002/\r\u0014X-\u0019;f\u001d\u0016<h)\u001a;dQ\u0016\u0014()\u0019:sS\u0016\u0014HCAA\r\u0011\u001d\tI\u0007\u0001C\u0001\u0003W\n\u0011cZ3u\r\u0016$8\r[3s\u0005\u0006\u0014(/[3s)\u0005a\bbBA8\u0001\u0011\u0005\u0011QM\u0001\u001dGJ,\u0017\r^3OK^4VM]5gS\u000e\fG/[8o\u0005\u0006\u0014(/[3s\u0011\u001d\t\u0019\b\u0001C\u0001\u0003W\nacZ3u-\u0016\u0014\u0018NZ5dCRLwN\u001c\"beJLWM\u001d\u0005\b\u0003o\u0002A\u0011BA3\u0003)Ig.\u001b;jC2L'0\u001a\u0005\b\u0003w\u0002A\u0011BA?\u0003uygMZ:fiJ+7\u000f]8og\u0016\u001cFO]5oO^KG\u000f[#se>\u0014H\u0003BA@\u0003\u000b\u00032aHAA\u0013\r\t\u0019\t\n\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0005\u001d\u0015\u0011\u0010a\u0001\u0003\u0013\u000bab\u001c4gg\u0016$(+Z:q_:\u001cX\rE\u0002i\u0003\u0017K1!!$j\u00059yeMZ:fiJ+7\u000f]8og\u0016Dq!!%\u0001\t\u0013\t)'A\ttKRLe.\u001b;jC2|eMZ:fiNDq!!&\u0001\t\u0003\t9*\u0001\bbI\u00124U\r^2iK\u0012$\u0015\r^1\u0015\u0011\u0005e\u0011\u0011TAO\u0003CCq!a'\u0002\u0014\u0002\u0007Q%A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:Dq!a(\u0002\u0014\u0002\u00071&A\u0005sKBd\u0017nY1JI\"9\u00111UAJ\u0001\u00049\u0017!\u00049beRLG/[8o\t\u0006$\u0018\rC\u0004\u0002(\u0002!\t!!+\u0002\u0013\u001d,Go\u00144gg\u0016$Hc\u0001&\u0002,\"9\u00111TAS\u0001\u0004)\u0003bBAX\u0001\u0011\u0005\u0011QM\u0001\u000fm\u0016\u0014\u0018NZ=DQ\u0016\u001c7nU;n\u0001")
public class ReplicaBuffer
implements Logging,
ScalaObject {
    public final Map kafka$tools$ReplicaBuffer$$expectedReplicasPerTopicAndPartition;
    private final Map<Integer, Seq<TopicAndPartition>> leadersPerBroker;
    private final int expectedNumFetchers;
    public final Map kafka$tools$ReplicaBuffer$$brokerMap;
    public final long kafka$tools$ReplicaBuffer$$initialOffsetTime;
    private final long reportInterval;
    private final Pool kafka$tools$ReplicaBuffer$$fetchOffsetMap;
    private final Pool kafka$tools$ReplicaBuffer$$messageSetCache;
    private final AtomicReference<CountDownLatch> fetcherBarrier;
    private final AtomicReference<CountDownLatch> verificationBarrier;
    private volatile long lastReportTime;
    private long kafka$tools$ReplicaBuffer$$maxLag;
    private long kafka$tools$ReplicaBuffer$$offsetWithMaxLag;
    private TopicAndPartition kafka$tools$ReplicaBuffer$$maxLagTopicAndPartition;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ReplicaBuffer replicaBuffer = this;
        synchronized (replicaBuffer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    public void trace(Function0 msg) {
        Logging$class.trace(this, msg);
    }

    public Object trace(Function0 e) {
        return Logging$class.trace(this, e);
    }

    public void trace(Function0 msg, Function0 e) {
        Logging$class.trace(this, msg, e);
    }

    public void swallowTrace(Function0 action) {
        Logging$class.swallowTrace(this, action);
    }

    public void debug(Function0 msg) {
        Logging$class.debug(this, msg);
    }

    public Object debug(Function0 e) {
        return Logging$class.debug(this, e);
    }

    public void debug(Function0 msg, Function0 e) {
        Logging$class.debug(this, msg, e);
    }

    public void swallowDebug(Function0 action) {
        Logging$class.swallowDebug(this, action);
    }

    public void info(Function0 msg) {
        Logging$class.info(this, msg);
    }

    public Object info(Function0 e) {
        return Logging$class.info(this, e);
    }

    public void info(Function0 msg, Function0 e) {
        Logging$class.info(this, msg, e);
    }

    public void swallowInfo(Function0 action) {
        Logging$class.swallowInfo(this, action);
    }

    public void warn(Function0 msg) {
        Logging$class.warn(this, msg);
    }

    public Object warn(Function0 e) {
        return Logging$class.warn(this, e);
    }

    public void warn(Function0 msg, Function0 e) {
        Logging$class.warn(this, msg, e);
    }

    public void swallowWarn(Function0 action) {
        Logging$class.swallowWarn(this, action);
    }

    public void swallow(Function0 action) {
        Logging$class.swallow(this, action);
    }

    public void error(Function0 msg) {
        Logging$class.error(this, msg);
    }

    public Object error(Function0 e) {
        return Logging$class.error(this, e);
    }

    public void error(Function0 msg, Function0 e) {
        Logging$class.error(this, msg, e);
    }

    public void swallowError(Function0 action) {
        Logging$class.swallowError(this, action);
    }

    public void fatal(Function0 msg) {
        Logging$class.fatal(this, msg);
    }

    public Object fatal(Function0 e) {
        return Logging$class.fatal(this, e);
    }

    public void fatal(Function0 msg, Function0 e) {
        Logging$class.fatal(this, msg, e);
    }

    public final Pool kafka$tools$ReplicaBuffer$$fetchOffsetMap() {
        return this.kafka$tools$ReplicaBuffer$$fetchOffsetMap;
    }

    public final Pool kafka$tools$ReplicaBuffer$$messageSetCache() {
        return this.kafka$tools$ReplicaBuffer$$messageSetCache;
    }

    private AtomicReference<CountDownLatch> fetcherBarrier() {
        return this.fetcherBarrier;
    }

    private AtomicReference<CountDownLatch> verificationBarrier() {
        return this.verificationBarrier;
    }

    private long lastReportTime() {
        return this.lastReportTime;
    }

    private void lastReportTime_$eq(long l) {
        this.lastReportTime = l;
    }

    public final long kafka$tools$ReplicaBuffer$$maxLag() {
        return this.kafka$tools$ReplicaBuffer$$maxLag;
    }

    public final void kafka$tools$ReplicaBuffer$$maxLag_$eq(long l) {
        this.kafka$tools$ReplicaBuffer$$maxLag = l;
    }

    public final long kafka$tools$ReplicaBuffer$$offsetWithMaxLag() {
        return this.kafka$tools$ReplicaBuffer$$offsetWithMaxLag;
    }

    public final void kafka$tools$ReplicaBuffer$$offsetWithMaxLag_$eq(long l) {
        this.kafka$tools$ReplicaBuffer$$offsetWithMaxLag = l;
    }

    private TopicAndPartition kafka$tools$ReplicaBuffer$$maxLagTopicAndPartition() {
        return this.kafka$tools$ReplicaBuffer$$maxLagTopicAndPartition;
    }

    public final void kafka$tools$ReplicaBuffer$$maxLagTopicAndPartition_$eq(TopicAndPartition topicAndPartition) {
        this.kafka$tools$ReplicaBuffer$$maxLagTopicAndPartition = topicAndPartition;
    }

    public void createNewFetcherBarrier() {
        this.fetcherBarrier().set(new CountDownLatch(this.expectedNumFetchers));
    }

    public CountDownLatch getFetcherBarrier() {
        return this.fetcherBarrier().get();
    }

    public void createNewVerificationBarrier() {
        this.verificationBarrier().set(new CountDownLatch(1));
    }

    public CountDownLatch getVerificationBarrier() {
        return this.verificationBarrier().get();
    }

    private void initialize() {
        this.kafka$tools$ReplicaBuffer$$expectedReplicasPerTopicAndPartition.keySet().foreach(new $anonfun$initialize$1(this));
        this.setInitialOffsets();
    }

    public final String kafka$tools$ReplicaBuffer$$offsetResponseStringWithError(OffsetResponse offsetResponse) {
        return ((TraversableOnce)offsetResponse.partitionErrorAndOffsets().filter(new $anonfun$kafka$tools$ReplicaBuffer$$offsetResponseStringWithError$1(this))).mkString();
    }

    private void setInitialOffsets() {
        this.leadersPerBroker.foreach(new $anonfun$setInitialOffsets$1(this));
    }

    public void addFetchedData(TopicAndPartition topicAndPartition, int replicaId, FetchResponsePartitionData partitionData) {
        ((Pool)this.kafka$tools$ReplicaBuffer$$messageSetCache().get(topicAndPartition)).put(BoxesRunTime.boxToInteger(replicaId), partitionData);
    }

    public long getOffset(TopicAndPartition topicAndPartition) {
        return BoxesRunTime.unboxToLong(this.kafka$tools$ReplicaBuffer$$fetchOffsetMap().get(topicAndPartition));
    }

    public void verifyCheckSum() {
        this.debug((Function0<String>)new $anonfun$verifyCheckSum$1(this));
        this.kafka$tools$ReplicaBuffer$$maxLag_$eq(-1L);
        this.kafka$tools$ReplicaBuffer$$messageSetCache().foreach(new $anonfun$verifyCheckSum$2(this));
        long currentTimeMs = SystemTime$.MODULE$.milliseconds();
        if (currentTimeMs - this.lastReportTime() > this.reportInterval) {
            Predef$.MODULE$.println(new StringBuilder().append((Object)ReplicaVerificationTool$.MODULE$.dateFormat().format(new Date(currentTimeMs))).append((Object)": max lag is ").append(BoxesRunTime.boxToLong(this.kafka$tools$ReplicaBuffer$$maxLag())).append((Object)" for partition ").append(this.kafka$tools$ReplicaBuffer$$maxLagTopicAndPartition()).append((Object)" at offset ").append(BoxesRunTime.boxToLong(this.kafka$tools$ReplicaBuffer$$offsetWithMaxLag())).append((Object)" among ").append(BoxesRunTime.boxToInteger(this.kafka$tools$ReplicaBuffer$$messageSetCache().size())).append((Object)" paritions").toString());
            this.lastReportTime_$eq(currentTimeMs);
        }
    }

    public ReplicaBuffer(Map<TopicAndPartition, Integer> expectedReplicasPerTopicAndPartition, Map<Integer, Seq<TopicAndPartition>> leadersPerBroker, int expectedNumFetchers, Map<Integer, Broker> brokerMap, long initialOffsetTime, long reportInterval) {
        this.kafka$tools$ReplicaBuffer$$expectedReplicasPerTopicAndPartition = expectedReplicasPerTopicAndPartition;
        this.leadersPerBroker = leadersPerBroker;
        this.expectedNumFetchers = expectedNumFetchers;
        this.kafka$tools$ReplicaBuffer$$brokerMap = brokerMap;
        this.kafka$tools$ReplicaBuffer$$initialOffsetTime = initialOffsetTime;
        this.reportInterval = reportInterval;
        Logging$class.$init$(this);
        this.kafka$tools$ReplicaBuffer$$fetchOffsetMap = new Pool(Pool$.MODULE$.init$default$1());
        this.kafka$tools$ReplicaBuffer$$messageSetCache = new Pool(Pool$.MODULE$.init$default$1());
        this.fetcherBarrier = new AtomicReference<CountDownLatch>(new CountDownLatch(expectedNumFetchers));
        this.verificationBarrier = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
        this.lastReportTime = SystemTime$.MODULE$.milliseconds();
        this.kafka$tools$ReplicaBuffer$$maxLag = -1L;
        this.kafka$tools$ReplicaBuffer$$offsetWithMaxLag = -1L;
        this.kafka$tools$ReplicaBuffer$$maxLagTopicAndPartition = null;
        this.initialize();
    }
}

