% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common-compile_code.R
\name{compile_code}
\alias{compile_code}
\title{Compile code associated to a user-defined operator with cmake}
\usage{
compile_code(formula, var_aliases, dllname, cmake_dir)
}
\arguments{
\item{formula}{text string, formula defining the new operator.}

\item{var_aliases}{text string, formated formula input arguments returned by
\code{\link[=format_var_aliases]{format_var_aliases()}} (specifically \verb{$var_aliases}).}

\item{dllname}{text string, the name associated to the related shared object
file.}

\item{cmake_dir}{text string, directory where to find the \code{CMakeLists.txt}
file.}
}
\value{
an exit code (integer value), 0 if no problem, not 0 otherwise.
}
\description{
The function \code{compile_code} is a wrapper to call cmake used in the function
\code{\link[=compile_formula]{compile_formula()}}.
}
\details{
The function \code{compile_code} should only be called in the directory where the
build (i.e. generation of related cmake and so files) will be done.

The corresponging \code{CMakeLists.txt} file is located in directory \code{cmake_dir}
given as input argument.
}
\seealso{
\code{\link[=compile_formula]{compile_formula()}}, \code{\link[=format_var_aliases]{format_var_aliases()}}
}
\author{
Ghislain Durif
}
\keyword{internal}
