% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd.R
\name{new_cnd}
\alias{new_cnd}
\alias{cnd_error}
\alias{cnd_warning}
\alias{cnd_message}
\title{Create a condition object}
\usage{
new_cnd(.type = NULL, ..., .msg = NULL)

cnd_error(.type = NULL, ..., .msg = NULL)

cnd_warning(.type = NULL, ..., .msg = NULL)

cnd_message(.type = NULL, ..., .msg = NULL)
}
\arguments{
\item{.type}{The condition subclass.}

\item{...}{Named data fields stored inside the condition
object. These dots are evaluated with \link[=dots_list]{explicit
splicing}.}

\item{.msg}{A default message to inform the user about the
condition when it is signalled.}
}
\description{
These constructors make it easy to create subclassed conditions.
Conditions are objects that power the error system in R. They can
also be used for passing messages to pre-established handlers.
}
\details{
\code{new_cnd()} creates objects inheriting from \code{condition}. Conditions
created with \code{cnd_error()}, \code{cnd_warning()} and \code{cnd_message()}
inherit from \code{error}, \code{warning} or \code{message}.
}
\examples{
# Create a condition inheriting from the s3 type "foo":
cnd <- new_cnd("foo")

# Signal the condition to potential handlers. This has no effect if no
# handler is registered to deal with conditions of type "foo":
cnd_signal(cnd)

# If a relevant handler is on the current evaluation stack, it will be
# called by cnd_signal():
with_handlers(cnd_signal(cnd), foo = exiting(function(c) "caught!"))

# Handlers can be thrown or executed inplace. See with_handlers()
# documentation for more on this.


# Note that merely signalling a condition inheriting of "error" is
# not sufficient to stop a program:
cnd_signal(cnd_error("my_error"))

# you need to use stop() to signal a critical condition that should
# terminate the program if not handled:
# stop(cnd_error("my_error"))
}
\seealso{
\code{\link[=cnd_signal]{cnd_signal()}}, \code{\link[=with_handlers]{with_handlers()}}.
}
