% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr.R
\name{set_expr}
\alias{set_expr}
\alias{get_expr}
\title{Set and get an expression}
\usage{
set_expr(x, value)

get_expr(x, default = x)
}
\arguments{
\item{x}{An expression or one-sided formula. In addition,
\code{set_expr()} accept frames.}

\item{value}{An updated expression.}

\item{default}{A default expression to return when \code{x} is not an
expression wrapper. Defaults to \code{x} itself.}
}
\value{
The updated original input for \code{set_expr()}. A raw
expression for \code{get_expr()}.
}
\description{
These helpers are useful to make your function work generically
with quosures and raw expressions. First call \code{get_expr()} to
extract an expression. Once you're done processing the expression,
call \code{set_expr()} on the original object to update the expression.
You can return the result of \code{set_expr()}, either a formula or an
expression depending on the input type. Note that \code{set_expr()} does
not change its input, it creates a new object.
}
\examples{
f <- ~foo(bar)
e <- quote(foo(bar))
frame <- identity(identity(ctxt_frame()))

get_expr(f)
get_expr(e)
get_expr(frame)

set_expr(f, quote(baz))
set_expr(e, quote(baz))
}
