% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/types.R
\name{switch_lang}
\alias{switch_lang}
\alias{coerce_lang}
\alias{lang_type_of}
\title{Dispatch on call type}
\usage{
switch_lang(.x, ...)

coerce_lang(.x, .to, ...)

lang_type_of(x)
}
\arguments{
\item{.x, x}{A language object (a call). If a formula quote, the RHS
is extracted first.}

\item{...}{Named clauses. The names should be types as returned by
\code{lang_type_of()}.}

\item{.to}{This is useful when you switchpatch within a coercing
function. If supplied, this should be a string indicating the
target type. A catch-all clause is then added to signal an error
stating the conversion failure. This type is prettified unless
\code{.to} inherits from the S3 class \code{"AsIs"} (see \code{\link[base:I]{base::I()}}).}
}
\description{
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("experimental")}
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("questioning")}

\code{switch_lang()} dispatches clauses based on the subtype of call, as
determined by \code{lang_type_of()}. The subtypes are based on the type
of call head (see details).
}
\details{
Calls (objects of type \code{language}) do not necessarily call a named
function. They can also call an anonymous function or the result of
some other expression. The language subtypes are organised around
the kind of object being called:
\itemize{
\item For regular calls to named function, \code{switch_lang()} returns
"named".
\item Sometimes the function being called is the result of another
function call, e.g. \code{foo()()}, or the result of another
subsetting call, e.g. \code{foo$bar()} or \code{foo@bar()}. In this case,
the call head is not a symbol, it is another call (e.g. to the
infix functions \code{$} or \code{@}). The call subtype is said to be
"recursive".
\item A special subset of recursive calls are namespaced calls like
\code{foo::bar()}. \code{switch_lang()} returns "namespaced" for these
calls. It is generally a good idea if your function treats
\code{bar()} and \code{foo::bar()} similarly.
\item Finally, it is possible to have a literal (see \code{\link[=is_expression]{is_expression()}} for a
definition of literals) as call head. In most cases, this will be
a function inlined in the call (this is sometimes an expedient
way of dealing with scoping issues). For calls with a literal
node head, \code{switch_lang()} returns "inlined". Note that if a call
head contains a literal that is not function, something went
wrong and using that object will probably make R crash.
\code{switch_lang()} issues an error in this case.
}

The reason we use the term \emph{node head} is because calls are
structured as tree objects. This makes sense because the best
representation for language code is a tree whose hierarchy is
determined by the order of operations. See \link{node} for more on this.
}
\section{Life cycle}{


All these functions are in the questioning stage and likely to be
removed from the package.
}

\examples{
# Named calls:
lang_type_of(~foo())

# Recursive calls:
lang_type_of(~foo$bar())
lang_type_of(~foo()())

# Namespaced calls:
lang_type_of(~base::list())

# For an inlined call, let's inline a function in the head node:
call <- quote(foo(letters))
call[[1]] <- base::toupper

call
lang_type_of(call)
}
\keyword{internal}
