% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval.R
\name{exec}
\alias{exec}
\title{Execute a function}
\usage{
exec(.fn, ..., .env = caller_env())
}
\arguments{
\item{.fn}{A function, or function name as a string.}

\item{...}{<\link[=dyn-dots]{dynamic}> Arguments for \code{.fn}.}

\item{.env}{Environment in which to evaluate the call. This will be
most useful if \code{f} is a string, or the function has side-effects.}
}
\description{
This function constructs and evaluates a call to \code{.fn}.
It has two primary uses:
\itemize{
\item To call a function with arguments stored in a list (if the
function doesn't support \link[=dyn-dots]{dynamic dots}). Splice the
list of arguments with \code{!!!}.
\item To call every function stored in a list (in conjunction with \code{map()}/
\code{\link[=lapply]{lapply()}})
}
}
\examples{
args <- list(x = c(1:10, 100, NA), na.rm = TRUE)
exec("mean", !!!args)
exec("mean", !!!args, trim = 0.2)

fs <- list(a = function() "a", b = function() "b")
lapply(fs, exec)

# Compare to do.call it will not automatically inline expressions
# into the evaluated call.
x <- 10
args <- exprs(x1 = x + 1, x2 = x * 2)
exec(list, !!!args)
do.call(list, args)

# exec() is not designed to generate pretty function calls. This is
# most easily seen if you call a function that captures the call:
f <- disp ~ cyl
exec("lm", f, data = mtcars)

# If you need finer control over the generated call, you'll need to
# construct it yourself. This may require creating a new environment
# with carefully constructed bindings
data_env <- env(data = mtcars)
eval(expr(lm(!!f, data)), data_env)
}
