% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse-defuse.R
\name{embrace-operator}
\alias{embrace-operator}
\alias{curly-curly}
\title{Embrace operator \verb{\{\{}}
\description{
The embrace operator \verb{\{\{} is used to create functions that call
other \link[=topic-data-mask]{data-masking} functions. It transports a
data-masked argument (an argument that can refer to columns of a
data frame) from one function to another.\if{html}{\out{<div class="sourceCode r">}}\preformatted{my_mean <- function(data, var) \{
  dplyr::summarise(data, mean = mean(\{\{ var \}\}))
\}
}\if{html}{\out{</div>}}
}
\section{Under the hood}{


\verb{\{\{} combines \code{\link[=enquo]{enquo()}} and \code{\link[=injection-operator]{!!}} in one
step. The snippet above is equivalent to:\if{html}{\out{<div class="sourceCode r">}}\preformatted{my_mean <- function(data, var) \{
  var <- enquo(var)
  dplyr::summarise(data, mean = mean(!!var))
\}
}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \ifelse{html}{\link[=topic-data-mask]{What is data-masking and why do I need \{\{?}}{\link[=topic-data-mask]{What is data-masking and why do I need curly-curly?}}
\item \ifelse{html}{\link[=topic-data-mask-programming]{Data mask programming patterns}}{\link[=topic-data-mask-programming]{Data mask programming patterns}}
}
}
