% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{quosure-tools}
\alias{quosure-tools}
\alias{quosure}
\alias{quo_is_missing}
\alias{quo_is_symbol}
\alias{quo_is_call}
\alias{quo_is_symbolic}
\alias{quo_is_null}
\alias{quo_get_expr}
\alias{quo_get_env}
\alias{quo_set_expr}
\alias{quo_set_env}
\title{Quosure getters, setters and predicates}
\usage{
quo_is_missing(quo)

quo_is_symbol(quo, name = NULL)

quo_is_call(quo, name = NULL, n = NULL, ns = NULL)

quo_is_symbolic(quo)

quo_is_null(quo)

quo_get_expr(quo)

quo_get_env(quo)

quo_set_expr(quo, expr)

quo_set_env(quo, env)
}
\arguments{
\item{quo}{A quosure to test.}

\item{name}{The name of the symbol or function call. If \code{NULL} the
name is not tested.}

\item{n}{An optional number of arguments that the call should
match.}

\item{ns}{The namespace of the call. If \code{NULL}, the namespace
doesn't participate in the pattern-matching. If an empty string
\code{""} and \code{x} is a namespaced call, \code{is_call()} returns
\code{FALSE}. If any other string, \code{is_call()} checks that \code{x} is
namespaced within \code{ns}.

Can be a character vector of namespaces, in which case the call
has to match at least one of them, otherwise \code{is_call()} returns
\code{FALSE}.}

\item{expr}{A new expression for the quosure.}

\item{env}{A new environment for the quosure.}
}
\description{
These tools inspect and modify \link[=topic-quosure]{quosures}, a type of
\link[=topic-defuse]{defused expression} that includes a reference to the
context where it was created. A quosure is guaranteed to evaluate
in its original environment and can refer to local objects safely.
\itemize{
\item You can access the quosure components with \code{quo_get_expr()} and
\code{quo_get_env()}.
\item The \code{quo_} prefixed predicates test the expression of a quosure,
\code{quo_is_missing()}, \code{quo_is_symbol()}, etc.
}

All \code{quo_} prefixed functions expect a quosure and will fail if
supplied another type of object. Make sure the input is a quosure
with \code{\link[=is_quosure]{is_quosure()}}.
}
\section{Empty quosures and missing arguments}{

When missing arguments are captured as quosures, either through
\code{\link[=enquo]{enquo()}} or \code{\link[=quos]{quos()}}, they are returned as an empty quosure. These
quosures contain the \link[=missing_arg]{missing argument} and typically
have the \link[=empty_env]{empty environment} as enclosure.

Use \code{quo_is_missing()} to test for a missing argument defused with
\code{\link[=enquo]{enquo()}}.
}

\examples{
quo <- quo(my_quosure)
quo


# Access and set the components of a quosure:
quo_get_expr(quo)
quo_get_env(quo)

quo <- quo_set_expr(quo, quote(baz))
quo <- quo_set_env(quo, empty_env())
quo

# Test wether an object is a quosure:
is_quosure(quo)

# If it is a quosure, you can use the specialised type predicates
# to check what is inside it:
quo_is_symbol(quo)
quo_is_call(quo)
quo_is_null(quo)

# quo_is_missing() checks for a special kind of quosure, the one
# that contains the missing argument:
quo()
quo_is_missing(quo())

fn <- function(arg) enquo(arg)
fn()
quo_is_missing(fn())
}
\seealso{
\itemize{
\item \code{\link[=quo]{quo()}} for creating quosures by \link[=topic-defuse]{argument defusal}.
\item \code{\link[=new_quosure]{new_quosure()}} and \code{\link[=as_quosure]{as_quosure()}} for assembling quosures from
components.
\item \ifelse{html}{\link[=topic-quosure]{What are quosures and when are they needed?}}{\link[=topic-quosure]{What are quosures and when are they needed?}} for an overview.
}
}
