% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-message.R
\name{cnd_message}
\alias{cnd_message}
\alias{cnd_header}
\alias{cnd_body}
\alias{cnd_footer}
\title{Build an error message from parts}
\usage{
cnd_message(cnd, ..., inherit = TRUE, prefix = FALSE)

cnd_header(cnd, ...)

cnd_body(cnd, ...)

cnd_footer(cnd, ...)
}
\arguments{
\item{cnd}{A condition object.}

\item{...}{Arguments passed to methods.}

\item{inherit}{Wether to include parent messages. Parent messages
are printed with a "Caused by error:" prefix, even if \code{prefix} is
\code{FALSE}.}

\item{prefix}{Whether to print the full message, including the
condition prefix (\verb{Error:}, \verb{Warning:}, \verb{Message:}, or
\verb{Condition:}). The prefix mentions the \code{call} field if present,
and the \code{srcref} info if present. If \code{cnd} has a \code{parent} field
(i.e. the condition is chained), the parent messages are included
in the message with a \verb{Caused by} prefix.}
}
\description{
\code{cnd_message()} assembles an error message from three generics:
\itemize{
\item \code{cnd_header()}
\item \code{cnd_body()}
\item \code{cnd_footer()}
}

Methods for these generics must return a character vector. The
elements are combined into a single string with a newline
separator. Bullets syntax is supported, either through rlang (see
\code{\link[=format_error_bullets]{format_error_bullets()}}), or through cli if the condition has
\code{use_cli_format} set to \code{TRUE}.

The default method for the error header returns the \code{message} field
of the condition object. The default methods for the body and
footer return the the \code{body} and \code{footer} fields if any, or empty
character vectors otherwise.

\code{cnd_message()} is automatically called by the \code{conditionMessage()}
for rlang errors, warnings, and messages. Error classes created
with \code{\link[=abort]{abort()}} only need to implement header, body or footer
methods. This provides a lot of flexibility for hierarchies of
error classes, for instance you could inherit the body of an error
message from a parent class while overriding the header and footer.
}
\section{Overriding header, body, and footer methods}{


Sometimes the contents of an error message depends on the state of
your checking routine. In that case, it can be tricky to lazily
generate error messages with \code{cnd_header()}, \code{cnd_body()}, and
\code{cnd_footer()}: you have the choice between overspecifying your
error class hierarchies with one class per state, or replicating
the type-checking control flow within the \code{cnd_body()} method. None
of these options are ideal.

A better option is to define \code{header}, \code{body}, or \code{footer} fields
in your condition object. These can be a static string, a
\link[=as_function]{lambda-formula}, or a function with the same
signature as \code{cnd_header()}, \code{cnd_body()}, or \code{cnd_footer()}. These
fields override the message generics and make it easy to generate
an error message tailored to the state in which the error was
constructed.
}

