% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic-nse.R
\name{topic-inject-out-of-context}
\alias{topic-inject-out-of-context}
\title{What happens if I use injection operators out of context?}
\description{
The \link[=topic-inject]{injection operators} \ifelse{html}{\code{\link[=embrace-operator]{\{\{}}}{\verb{\{\{}}, \code{\link[=injection-operator]{!!}}, and \code{\link[=splice-operator]{!!!}} are an extension of the R syntax developed for tidyverse packages. Because they are not part of base R, they suffer from some limitations. In particular no specific error is thrown when they are used in unexpected places.
\subsection{Using \verb{\{\{} out of context}{

The embrace operator \ifelse{html}{\code{\link[=embrace-operator]{\{\{}}}{\verb{\{\{}} is a feature available in \link[=topic-data-mask]{data-masked} arguments powered by tidy eval. If you use it elsewhere, it is interpreted as a double \verb{\{} wrapping.

In the R language, \verb{\{} is like \code{(} but takes multiple expressions instead of one:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{\{
  1 # Discarded
  2
\}
#> [1] 2
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{
list(
  \{ message("foo"); 2 \}
)
#> foo
#> [[1]]
#> [1] 2
}\if{html}{\out{</div>}}

Just like you can wrap an expression in as many parentheses as you'd like, you can wrap multiple times with braces:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{((1))
#> [1] 1
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{
\{\{ 2 \}\}
#> [1] 2
}\if{html}{\out{</div>}}

So nothing prevents you from embracing a function argument in a context where this operation is not implemented. R will just treat the braces like a set of parentheses and silently return the result:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{f <- function(arg) list(\{\{ arg \}\})
f(1)
#> [[1]]
#> [1] 1
}\if{html}{\out{</div>}}

This sort of no-effect embracing should be avoided in real code because it falsely suggests that the function supports the tidy eval operator and that something special is happening.

However in many cases embracing is done to implement \link[=topic-data-mask]{data masking}. It is likely that the function will be called with data-variables references which R won't be able to resolve properly:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{my_mean <- function(data, var) \{
  with(data, mean(\{\{ var \}\}))
\}

my_mean(mtcars, cyl)
#> Error:
#> ! object 'cyl' not found
}\if{html}{\out{</div>}}

Since \code{\link[=with]{with()}} is a base data-masking function that doesn't support tidy eval operators, the embrace operator does not work and we get an object not found error.
}

\subsection{Using \verb{!!} and \verb{!!!} out of context}{

The injection operators \code{\link{!!}} and \code{\link{!!!}} are implemented in \link[=topic-data-mask]{data-masked} arguments, \link[=dyn-dots]{dynamic dots}, and within \code{\link[=inject]{inject()}}. When used in other contexts, they are interpreted by R as double and triple \emph{negations}.

Double negation can be used in ordinary code to convert an input to logical:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{!!10
#> [1] TRUE
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{
!!0
#> [1] FALSE
}\if{html}{\out{</div>}}

Triple negation is essentially the same as simple negation:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{!10
#> [1] FALSE
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{
!!!10
#> [1] FALSE
}\if{html}{\out{</div>}}

This means that when injection operators are used in the wrong place, they will be interpreted as negation. In the best case scenario you will get a type error:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{!"foo"
#> Error in `!"foo"`:
#> ! invalid argument type
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{
!quote(foo)
#> Error in `!quote(foo)`:
#> ! invalid argument type
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{
!quote(foo())
#> Error in `!quote(foo())`:
#> ! invalid argument type
}\if{html}{\out{</div>}}

In the worst case, R will silently convert the input to logical. Unfortunately there is no systematic way of checking for these errors.
}
}
\keyword{internal}
