% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Maximum-Flow-Algorithms-1}
\alias{Maximum-Flow-Algorithms-1}
\alias{PreflowRunner}
\alias{EdmondsKarpRunner}
\title{Maximum Flow Algorithms}
\usage{
PreflowRunner(
  arcSources,
  arcTargets,
  arcDistances,
  sourceNode,
  destinationNode,
  numNodes
)

EdmondsKarpRunner(
  arcSources,
  arcTargets,
  arcDistances,
  sourceNode,
  destinationNode,
  numNodes
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's edges}

\item{arcDistances}{Vector corresponding to the capacities of nodes of a graph's edges}

\item{sourceNode}{The source node}

\item{destinationNode}{The destination node}

\item{numNodes}{The number of nodes in the graph}
}
\value{
A list containing three entries: 1) A list corresponding to the flows of arcs in the graph, 2) A list of cut-values of the graph's nodes, and 3) the total cost of the flows in the graph, i.e. the maxflow value.
}
\description{
`PreflowRunner` runs the Preflow Algorithm to calculate the maximum flow.

`EdmondsKarpRunner` runs the EdmondsKarp Algorithm to calculate the maximum flow.
}
