% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Minimum-Cost-Flow-Algorithms}
\alias{Minimum-Cost-Flow-Algorithms}
\alias{CycleCancellingRunner}
\alias{CapacityScalingRunner}
\alias{CostScalingRunner}
\alias{NetworkSimplexRunner}
\title{Minimum Cost Flow Algorithms}
\usage{
CycleCancellingRunner(
  arcSources,
  arcTargets,
  arcCapacities,
  arcCosts,
  nodeSupplies,
  numNodes
)

CapacityScalingRunner(
  arcSources,
  arcTargets,
  arcCapacities,
  arcCosts,
  nodeSupplies,
  numNodes
)

CostScalingRunner(
  arcSources,
  arcTargets,
  arcCapacities,
  arcCosts,
  nodeSupplies,
  numNodes
)

NetworkSimplexRunner(
  arcSources,
  arcTargets,
  arcCapacities,
  arcCosts,
  nodeSupplies,
  numNodes
)
}
\arguments{
\item{arcSources, }{a vector corresponding to the source nodes of a graph's edges}

\item{arcTargets, }{a vector corresponding to the destination nodes of a graph's edges}

\item{arcCapacities, }{a vector corresponding to the capacities of nodes of a graph's edges}

\item{arcCosts, }{a vector corresponding to the capacities of nodes of a graph's edges}

\item{nodeSupplies, }{a vector corresponding to the supplies of each node}

\item{numNodes, }{the number of nodes in the graph}
}
\value{
A list containing three entries: 1) A list corresponding to the flows of arcs in the graph, 2) A list of potentials of the graph's nodes, and 3) the total cost of the flows in the graph, i.e. the mincostflow value
}
\description{
`CycleCancellingRunner` runs the Cycle-Cancelling Algorithm to calculate the minimum cost flow.

`CapacityScalingRunner` runs the Capacity-Scaling Algorithm to calculate the minimum cost flow.

`CostScalingRunner` runs the Cost-Scaling Algorithm to calculate the minimum cost flow.

`NetworkSimplexRunner` runs the Network-Simplex Algorithm to calculate the minimum cost flow.
}
